# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.xml_writer import XMLWriter


class XMLTableWriter(XMLWriter):
    """
    XMLTableWriter - Write VTK XML Table files.
    
    Superclass: XMLWriter
    
    XMLTableWriter provides a functionality for writing vt_table as XML
    .vtt files.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXMLTableWriter, obj, update, **traits)
    
    number_of_pieces = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the number of pieces used to stream the table through the
        pipeline while writing to the file.
        """
    )

    def _number_of_pieces_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfPieces,
                        self.number_of_pieces)

    write_piece = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the piece to write to the file.  If this is negative or
        equal to the number_of_pieces, all pieces will be written.
        """
    )

    def _write_piece_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWritePiece,
                        self.write_piece)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        Assign a data object as input. Note that this method does not
        establish a pipeline connection. Use set_input_connection() to
        setup a pipeline connection.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('release_data_flag', 'GetReleaseDataFlag'), ('number_of_pieces',
    'GetNumberOfPieces'), ('progress', 'GetProgress'), ('header_type',
    'GetHeaderType'), ('id_type', 'GetIdType'), ('data_mode',
    'GetDataMode'), ('reference_count', 'GetReferenceCount'),
    ('byte_order', 'GetByteOrder'), ('block_size', 'GetBlockSize'),
    ('abort_execute', 'GetAbortExecute'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('debug', 'GetDebug'),
    ('encode_appended_data', 'GetEncodeAppendedData'),
    ('number_of_time_steps', 'GetNumberOfTimeSteps'), ('file_name',
    'GetFileName'), ('progress_text', 'GetProgressText'),
    ('write_to_output_string', 'GetWriteToOutputString'), ('write_piece',
    'GetWritePiece'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'encode_appended_data',
    'global_warning_display', 'release_data_flag',
    'write_to_output_string', 'byte_order', 'data_mode', 'header_type',
    'id_type', 'block_size', 'file_name', 'number_of_pieces',
    'number_of_time_steps', 'progress_text', 'write_piece'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(XMLTableWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit XMLTableWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['encode_appended_data', 'write_to_output_string'],
            ['byte_order', 'data_mode', 'header_type', 'id_type'], ['block_size',
            'file_name', 'number_of_pieces', 'number_of_time_steps',
            'write_piece']),
            title='Edit XMLTableWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit XMLTableWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

