# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_algorithm import ImageAlgorithm


class UnsignedDistance(ImageAlgorithm):
    """
    UnsignedDistance - compute unsigned (i.e., non-negative) distances
    from an input point cloud
    
    Superclass: ImageAlgorithm
    
    UnsignedDistance is a filter that computes non-negative (i.e.,
    unsigned) distances over a volume from an input point cloud. This
    filter is distinct from SignedDistance in that it does not require
    point normals. However, isocontouring a zero-valued distance function
    (e.g., trying to fit a surface will produce unsatisfactory results).
    Rather this filter, when combined with an isocontouring filter such
    as FlyingEdges3D, can produce an offset, bounding surface
    surrounding the input point cloud.
    
    To use this filter, specify the input PolyData (which represents
    the point cloud); define the sampling volume; specify a radius (which
    limits the radius of influence of each point); and set an optional
    point locator (to accelerate proximity operations, a
    StaticPointLocator is used by default). Note that large radius
    values may have significant impact on performance. The volume is
    defined by specifying dimensions in the x-y-z directions, as well as
    a domain bounds. By default the model bounds are defined from the
    input points, but the user can also manually specify them. Finally,
    because the radius data member limits the influence of the distance
    calulation, some voxels may receive no contribution. These voxel
    values are set to the cap_value.
    
    This filter has one other unusual capability: it is possible to
    append data in a sequence of operations to generate a single output.
    This is useful when you have multiple point clouds (e.g., possibly
    from multiple acqusition scans) and want to incrementally accumulate
    all the data. However, the user must be careful to either specify the
    Bounds or order the input such that the bounds of the first input
    completely contains all other input data.  This is because the
    geometry and topology of the output sampling volume cannot be changed
    after the initial Append operation.
    
    @warning
    Note that multiple, non-connected surfaces may be produced. For
    example, if the point cloud is from the surface of the sphere, it is
    possible to generate two surfaces (with isocontouring): one inside
    the sphere, one outside the sphere. It is sometimes possible to
    select the surface you want from the output of the contouring filter
    by using PolyDataConnectivityFilter.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    SignedDistance ExtractSurface ImplicitModeller
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkUnsignedDistance, obj, update, **traits)
    
    capping = tvtk_base.true_bool_trait(desc=\
        """
        The outer boundary of the volume can be assigned a particular
        value after distances are computed. This can be used to close or
        "cap" all surfaces during isocontouring.
        """
    )

    def _capping_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCapping,
                        self.capping_)

    adjust_bounds = tvtk_base.true_bool_trait(desc=\
        """
        Control how the model bounds are computed. If the ivar
        adjust_bounds is set, then the bounds specified (or computed
        automatically) is modified by the fraction given by
        adjust_distance. This means that the model bounds is expanded in
        each of the x-y-z directions.
        """
    )

    def _adjust_bounds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAdjustBounds,
                        self.adjust_bounds_)

    def get_output_scalar_type(self):
        """
        V.get_output_scalar_type() -> int
        C++: virtual int GetOutputScalarType()
        Set the desired output scalar type. Currently only real types are
        supported. By default, VTK_FLOAT scalars are created.
        """
        ret = self._vtk_obj.GetOutputScalarType()
        return ret
        

    def set_output_scalar_type(self, *args):
        """
        V.set_output_scalar_type(int)
        C++: virtual void SetOutputScalarType(int _arg)
        Set the desired output scalar type. Currently only real types are
        supported. By default, VTK_FLOAT scalars are created.
        """
        ret = self._wrap_call(self._vtk_obj.SetOutputScalarType, *args)
        return ret

    def set_output_scalar_type_to_double(self):
        """
        V.set_output_scalar_type_to_double()
        C++: void SetOutputScalarTypeToDouble()
        Set the desired output scalar type. Currently only real types are
        supported. By default, VTK_FLOAT scalars are created.
        """
        self._vtk_obj.SetOutputScalarTypeToDouble()

    def set_output_scalar_type_to_float(self):
        """
        V.set_output_scalar_type_to_float()
        C++: void SetOutputScalarTypeToFloat()
        Set the desired output scalar type. Currently only real types are
        supported. By default, VTK_FLOAT scalars are created.
        """
        self._vtk_obj.SetOutputScalarTypeToFloat()

    bounds = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="float", value=(0.0, 0.0, 0.0, 0.0, 0.0, 0.0), cols=3, desc=\
        """
        
        """
    )

    def _bounds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBounds,
                        self.bounds)

    def _get_locator(self):
        return wrap_vtk(self._vtk_obj.GetLocator())
    def _set_locator(self, arg):
        old_val = self._get_locator()
        self._wrap_call(self._vtk_obj.SetLocator,
                        deref_vtk(arg))
        self.trait_property_changed('locator', old_val, arg)
    locator = traits.Property(_get_locator, _set_locator, desc=\
        """
        Specify a point locator. By default a StaticPointLocator is
        used. The locator performs efficient searches to locate points
        surrounding a voxel (within the specified radius).
        """
    )

    cap_value = traits.Float(9.999999680285692e+37, enter_set=True, auto_set=False, desc=\
        """
        Specify the capping value to use. The cap_value is also used as an
        initial distance value at each point in the dataset. By default,
        the cap_value is VTK_FLOAT_MAX;
        """
    )

    def _cap_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCapValue,
                        self.cap_value)

    adjust_distance = traits.Trait(0.0125, traits.Range(-1.0, 1.0, enter_set=True, auto_set=False), desc=\
        """
        Specify the amount to grow the model bounds (if the ivar
        adjust_bounds is set). The value is a fraction of the maximum
        length of the sides of the box specified by the model bounds.
        """
    )

    def _adjust_distance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAdjustDistance,
                        self.adjust_distance)

    dimensions = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int64", value=(256, 256, 256), cols=3, desc=\
        """
        Set/Get the i-j-k dimensions on which to computer the distance
        function.
        """
    )

    def _dimensions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDimensions,
                        self.dimensions)

    radius = traits.Trait(0.1, traits.Range(0.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        """
        Set / get the radius of influence of each point. Smaller values
        generally improve performance markedly.
        """
    )

    def _radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRadius,
                        self.radius)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def append(self, *args):
        """
        V.append(PolyData)
        C++: void Append(PolyData *input)
        Append a data set to the existing output. To use this function,
        you'll have to invoke the start_append() method before doing
        successive appends. It's also a good idea to specify the model
        bounds; otherwise the input model bounds is used. When you've
        finished appending, use the end_append() method.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Append, *my_args)
        return ret

    def end_append(self):
        """
        V.end_append()
        C++: void EndAppend()
        Method completes the append process.
        """
        ret = self._vtk_obj.EndAppend()
        return ret
        

    def start_append(self):
        """
        V.start_append()
        C++: void StartAppend()
        Initialize the filter for appending data. You must invoke the
        start_append() method before doing successive Appends(). It's also
        a good idea to manually specify the model bounds; otherwise the
        input bounds for the data will be used.
        """
        ret = self._vtk_obj.StartAppend()
        return ret
        

    _updateable_traits_ = \
    (('global_warning_display', 'GetGlobalWarningDisplay'),
    ('abort_execute', 'GetAbortExecute'), ('adjust_distance',
    'GetAdjustDistance'), ('capping', 'GetCapping'), ('progress_text',
    'GetProgressText'), ('bounds', 'GetBounds'), ('progress',
    'GetProgress'), ('reference_count', 'GetReferenceCount'),
    ('dimensions', 'GetDimensions'), ('release_data_flag',
    'GetReleaseDataFlag'), ('cap_value', 'GetCapValue'), ('radius',
    'GetRadius'), ('adjust_bounds', 'GetAdjustBounds'), ('debug',
    'GetDebug'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'adjust_bounds', 'capping', 'debug',
    'global_warning_display', 'release_data_flag', 'adjust_distance',
    'bounds', 'cap_value', 'dimensions', 'progress_text', 'radius'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(UnsignedDistance, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit UnsignedDistance properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['adjust_bounds', 'capping'], [], ['adjust_distance', 'bounds',
            'cap_value', 'dimensions', 'radius']),
            title='Edit UnsignedDistance properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit UnsignedDistance properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

