# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.context_device2d import ContextDevice2D


class SVGContextDevice2D(ContextDevice2D):
    """
    SVGContextDevice2D - ContextDevice2D implementation for use
    with SVGExporter.
    
    Superclass: ContextDevice2D
    
    Limitations:
    - The Nearest/Linear texture properties are ignored, since SVG
      doesn't provide any reliable control over interpolation.
    - Embedded fonts are experimental and poorly tested. Viewer support
      is lacking at the time of writing, hence the feature is largely
      useless. By default, fonts are not embedded since they're basically
    useless bloat.
    - text_as_path is enabled by default, since viewers differ wildly in
      how they handle text objects (eg. Inkscape renders at expected
      size, but webkit is way too big).
    - Pattern fills and markers are not shown on some viewers, e.g. KDE's
    okular (Webkit seems to work, though).
    - Clipping seems to be broken in most viewers. Webkit is buggy and
      forces the clip coordinates to object_bounding_box, even when
      explicitly set to user_space_on_use.
    - Many viewers anti-alias the output, leaving thin outlines around
      the triangles that make up larger polygons. This is a viewer issue
      and there not much we can do about it from the VTK side of things
      (and most viewers don't seem to have an antialiasing toggle,
      either...).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSVGContextDevice2D, obj, update, **traits)
    
    embed_fonts = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _embed_fonts_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEmbedFonts,
                        self.embed_fonts_)

    text_as_path = tvtk_base.true_bool_trait(desc=\
        """
        
        """
    )

    def _text_as_path_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTextAsPath,
                        self.text_as_path_)

    def get_matrix(self, *args):
        """
        V.get_matrix(Matrix3x3)
        
        Set the model view matrix for the display
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetMatrix, *my_args)
        return ret

    def set_matrix(self, *args):
        """
        V.set_matrix(Matrix3x3)
        
        Set the model view matrix for the display
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetMatrix, *my_args)
        return ret

    subdivision_threshold = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _subdivision_threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSubdivisionThreshold,
                        self.subdivision_threshold)

    def generate_definitions(self):
        """
        V.generate_definitions()
        C++: void GenerateDefinitions()
        Write any definition information (fonts, images, etc) that are
        accumulated between actors.
        """
        ret = self._vtk_obj.GenerateDefinitions()
        return ret
        

    def set_svg_context(self, *args):
        """
        V.set_svg_context(XMLDataElement, XMLDataElement)
        C++: void SetSVGContext(XMLDataElement *context,
            XMLDataElement *defs)
        The svg container element to draw into, and the global
        definitions element.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSVGContext, *my_args)
        return ret

    _updateable_traits_ = \
    (('embed_fonts', 'GetEmbedFonts'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('debug', 'GetDebug'), ('reference_count',
    'GetReferenceCount'), ('text_as_path', 'GetTextAsPath'),
    ('subdivision_threshold', 'GetSubdivisionThreshold'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'embed_fonts', 'global_warning_display', 'text_as_path',
    'subdivision_threshold'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SVGContextDevice2D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SVGContextDevice2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['embed_fonts', 'text_as_path'], [], ['subdivision_threshold']),
            title='Edit SVGContextDevice2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SVGContextDevice2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

