# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.depth_image_processing_pass import DepthImageProcessingPass


class SimpleMotionBlurPass(DepthImageProcessingPass):
    """
    SimpleMotionBlurPass - Avergae frames to simulate motion blur.
    
    Superclass: DepthImageProcessingPass
    
    A slow and simple approach that simply renders multiple frames and
    accumulates them before displaying them. As such it causes the render
    process to be sub_frames times slower than normal but handles all
    types of motion correctly as it is actually rendering all the sub
    frames.
    
    @sa
    RenderPass
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSimpleMotionBlurPass, obj, update, **traits)
    
    sub_frames = traits.Int(30, enter_set=True, auto_set=False, desc=\
        """
        Set the number of sub frames for doing motion blur. Once this is
        set greater than one, you will no longer see a new frame for
        every Render().  If you set this to five, you will need to do
        five Render() invocations before seeing the result. This isn't
        very impressive unless something is changing between the Renders.
        Changing this value may reset the current subframe count.
        """
    )

    def _sub_frames_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSubFrames,
                        self.sub_frames)

    def _get_color_texture(self):
        return wrap_vtk(self._vtk_obj.GetColorTexture())
    color_texture = traits.Property(_get_color_texture, desc=\
        """
        
        """
    )

    def _get_depth_texture(self):
        return wrap_vtk(self._vtk_obj.GetDepthTexture())
    depth_texture = traits.Property(_get_depth_texture, desc=\
        """
        
        """
    )

    def set_color_format(self, *args):
        """
        V.set_color_format(int)
        C++: virtual void SetColorFormat(int _arg)
        Set the format to use for the color texture
        TextureObject::Float16 TextureObject::Float32 and
        TextureObject::Fixed8 are supported. Fixed8 is the default.
        """
        ret = self._wrap_call(self._vtk_obj.SetColorFormat, *args)
        return ret

    def set_depth_format(self, *args):
        """
        V.set_depth_format(int)
        C++: virtual void SetDepthFormat(int _arg)
        Set the format to use for the depth texture e.g.
        TextureObject::Float32
        """
        ret = self._wrap_call(self._vtk_obj.SetDepthFormat, *args)
        return ret

    _updateable_traits_ = \
    (('global_warning_display', 'GetGlobalWarningDisplay'), ('sub_frames',
    'GetSubFrames'), ('debug', 'GetDebug'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'sub_frames'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SimpleMotionBlurPass, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SimpleMotionBlurPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['sub_frames']),
            title='Edit SimpleMotionBlurPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SimpleMotionBlurPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

