# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class PythonInteractiveInterpreter(Object):
    """
    PythonInteractiveInterpreter - interpreter for interactive shells.
    
    Superclass: Object
    
    PythonInteractiveInterpreter provides an interpreter that can be
    used in interactive shells. It mimicks the behaviour of the
    interactive console (much like the default Python shell) providing
    the "read-eval-print" loops. It also handles incomplete statements
    correctly. It uses "code" module provided by Python standard library
    to achieve this. It uses PythonInterpreter to ensure that the
    global Python environment is setup correctly. Note that any time the
    PythonInterpreter::Finalize() is called, the interactive
    interpreter will be destroyed as well. Subsequent calls to
    PythonInterpreter::Push() will reinitialize Python as start a new
    interactive interpreter shell.
    
    This class also observers and forwards all events invoked by a
    PythonInterpreter instance include Command::EnterEvent,
    Command::ExitEvent, Command::UpdateEvent,
    Command::ErrorEvent and Command::SetOutputEvent.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPythonInteractiveInterpreter, obj, update, **traits)
    
    def _get_interactive_console_locals_py_object(self):
        return self._vtk_obj.GetInteractiveConsoleLocalsPyObject()
    interactive_console_locals_py_object = traits.Property(_get_interactive_console_locals_py_object, desc=\
        """
        Provides access to the internal py_object instances used for the
        code._interactive_console() as well as the dictionary for the
        locals of the code._interactive_console() instance. Do not use if
        you are not sure what these are for.
        """
    )

    def _get_interactive_console_py_object(self):
        return self._vtk_obj.GetInteractiveConsolePyObject()
    interactive_console_py_object = traits.Property(_get_interactive_console_py_object, desc=\
        """
        Provides access to the internal py_object instances used for the
        code._interactive_console() as well as the dictionary for the
        locals of the code._interactive_console() instance. Do not use if
        you are not sure what these are for.
        """
    )

    def reset(self):
        """
        V.reset()
        C++: void Reset()
        This destroys the internal code._interactive_console instance.
        Hence, next time Push() will be called, it will use a brand new
        instance of code._interactive_console().
        """
        ret = self._vtk_obj.Reset()
        return ret
        

    def run_string_with_console_locals(self, *args):
        """
        V.run_string_with_console_locals(string) -> int
        C++: int RunStringWithConsoleLocals(const char *script)
        Executes the given python source code using the context given by
        the locals() object used by this interactive console.  This is
        similar to using PythonInterpreter::RunSimpleString(), except
        that method will execute code in the context of the __main__
        module. Returns 0 on success or -1 if an exception was raised.
        """
        ret = self._wrap_call(self._vtk_obj.RunStringWithConsoleLocals, *args)
        return ret

    _updateable_traits_ = \
    (('global_warning_display', 'GetGlobalWarningDisplay'), ('debug',
    'GetDebug'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PythonInteractiveInterpreter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PythonInteractiveInterpreter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit PythonInteractiveInterpreter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PythonInteractiveInterpreter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

