# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.handle_representation import HandleRepresentation


class MeasurementCubeHandleRepresentation3D(HandleRepresentation):
    """
    MeasurementCubeHandleRepresentation3D - represent a unit cube for
    measuring/comparing to data.
    
    Superclass: HandleRepresentation
    
    @sa
    PolygonalHandleRepresentation3D HandleRepresentation
    HandleWidget
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMeasurementCubeHandleRepresentation3D, obj, update, **traits)
    
    adaptive_scaling = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off adaptive scaling for the cube.
        """
    )

    def _adaptive_scaling_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAdaptiveScaling,
                        self.adaptive_scaling_)

    label_visibility = tvtk_base.true_bool_trait(desc=\
        """
        A label may be associated with the cube. The string can be set
        via set_label_text. The visibility of the label can be turned on /
        off.
        """
    )

    def _label_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLabelVisibility,
                        self.label_visibility_)

    handle_visibility = tvtk_base.true_bool_trait(desc=\
        """
        Toggle the visibility of the handle on and off
        """
    )

    def _handle_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHandleVisibility,
                        self.handle_visibility_)

    selected_label_visibility = tvtk_base.false_bool_trait(desc=\
        """
        A label may be associated with the cube. The string can be set
        via set_label_text. The visibility of the label can be turned on /
        off.
        """
    )

    def _selected_label_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSelectedLabelVisibility,
                        self.selected_label_visibility_)

    smooth_motion = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off smooth motion of the handle. See the documentation of
        move_focus_request for details. By default, smooth_motion is ON.
        However, in certain applications the user may want to turn it
        off. For instance when using certain specific point_placer's with
        the representation such as the CellCentersPointPlacer, which
        causes the representation to snap to the center of cells. In such
        cases, inherent restrictions on handle placement might conflict
        with a request for smooth motion of the handles.
        """
    )

    def _smooth_motion_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSmoothMotion,
                        self.smooth_motion_)

    side_length = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Set the length of a side of the cube (default is 1).
        """
    )

    def _side_length_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSideLength,
                        self.side_length)

    def _get_property(self):
        return wrap_vtk(self._vtk_obj.GetProperty())
    def _set_property(self, arg):
        old_val = self._get_property()
        self._wrap_call(self._vtk_obj.SetProperty,
                        deref_vtk(arg))
        self.trait_property_changed('property', old_val, arg)
    property = traits.Property(_get_property, _set_property, desc=\
        """
        Set/Get the handle properties when unselected and selected.
        """
    )

    min_relative_cube_screen_area = traits.Float(0.001, enter_set=True, auto_set=False, desc=\
        """
        Set the min/max cube representational area relative to the render
        window area. If adaptive scaling is on and the cube's image is
        outside of these bounds, the cube is adaptively scaled. The max
        and min relative cube sizes are clamped between 1. and 1.e-6, and
        max_relativeube_size must be more than greater than
        min_relative_cube_screen_area.
        """
    )

    def _min_relative_cube_screen_area_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinRelativeCubeScreenArea,
                        self.min_relative_cube_screen_area)

    def _get_selected_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedProperty())
    def _set_selected_property(self, arg):
        old_val = self._get_selected_property()
        self._wrap_call(self._vtk_obj.SetSelectedProperty,
                        deref_vtk(arg))
        self.trait_property_changed('selected_property', old_val, arg)
    selected_property = traits.Property(_get_selected_property, _set_selected_property, desc=\
        """
        Set/Get the handle properties when unselected and selected.
        """
    )

    length_unit = traits.String('unit', enter_set=True, auto_set=False, desc=\
        """
        Set the label for the unit of length of a side of the cube.
        """
    )

    def _length_unit_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLengthUnit,
                        self.length_unit)

    world_position = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        """
        Set the position of the point in world and display coordinates.
        """
    )

    def _world_position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWorldPosition,
                        self.world_position)

    label_text_input = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        A label may be associated with the cube. The string can be set
        via set_label_text. The visibility of the label can be turned on /
        off.
        """
    )

    def _label_text_input_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLabelTextInput,
                        self.label_text_input)

    rescale_factor = traits.Trait(2.0, traits.Range(1.0, 1e+299, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the rescaling increment for the cube. This value is
        applied to each dimension, so volume scaling =
        std::pow(_rescale_factor, 3).
        """
    )

    def _rescale_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRescaleFactor,
                        self.rescale_factor)

    display_position = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        """
        Set the position of the point in world and display coordinates.
        """
    )

    def _display_position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDisplayPosition,
                        self.display_position)

    max_relative_cube_screen_area = traits.Float(0.02, enter_set=True, auto_set=False, desc=\
        """
        Set the min/max cube representational area relative to the render
        window area. If adaptive scaling is on and the cube's image is
        outside of these bounds, the cube is adaptively scaled. The max
        and min relative cube sizes are clamped between 1. and 1.e-6, and
        max_relativeube_size must be more than greater than
        min_relative_cube_screen_area.
        """
    )

    def _max_relative_cube_screen_area_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxRelativeCubeScreenArea,
                        self.max_relative_cube_screen_area)

    def _get_handle(self):
        return wrap_vtk(self._vtk_obj.GetHandle())
    handle = traits.Property(_get_handle, desc=\
        """
        Get the handle polydata.
        """
    )

    def _get_label_text(self):
        return wrap_vtk(self._vtk_obj.GetLabelText())
    label_text = traits.Property(_get_label_text, desc=\
        """
        Get the label text actor
        """
    )

    def _get_transform(self):
        return wrap_vtk(self._vtk_obj.GetTransform())
    transform = traits.Property(_get_transform, desc=\
        """
        Get the transform used to transform the generic handle polydata
        before placing it in the render window
        """
    )

    _updateable_traits_ = \
    (('handle_visibility', 'GetHandleVisibility'),
    ('estimated_render_time', 'GetEstimatedRenderTime'),
    ('interaction_state', 'GetInteractionState'), ('need_to_render',
    'GetNeedToRender'), ('dragable', 'GetDragable'), ('world_position',
    'GetWorldPosition'), ('render_time_multiplier',
    'GetRenderTimeMultiplier'), ('length_unit', 'GetLengthUnit'),
    ('pickable', 'GetPickable'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('min_relative_cube_screen_area',
    'GetMinRelativeCubeScreenArea'), ('reference_count',
    'GetReferenceCount'), ('rescale_factor', 'GetRescaleFactor'),
    ('side_length', 'GetSideLength'), ('place_factor', 'GetPlaceFactor'),
    ('selected_label_visibility', 'GetSelectedLabelVisibility'),
    ('label_text_input', 'GetLabelTextInput'), ('constrained',
    'GetConstrained'), ('smooth_motion', 'GetSmoothMotion'),
    ('label_visibility', 'GetLabelVisibility'), ('debug', 'GetDebug'),
    ('visibility', 'GetVisibility'), ('display_position',
    'GetDisplayPosition'), ('active_representation',
    'GetActiveRepresentation'), ('use_bounds', 'GetUseBounds'),
    ('adaptive_scaling', 'GetAdaptiveScaling'),
    ('max_relative_cube_screen_area', 'GetMaxRelativeCubeScreenArea'),
    ('picking_managed', 'GetPickingManaged'), ('handle_size',
    'GetHandleSize'), ('tolerance', 'GetTolerance'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['active_representation', 'adaptive_scaling', 'constrained', 'debug',
    'dragable', 'global_warning_display', 'handle_visibility',
    'label_visibility', 'need_to_render', 'pickable', 'picking_managed',
    'selected_label_visibility', 'smooth_motion', 'use_bounds',
    'visibility', 'display_position', 'estimated_render_time',
    'handle_size', 'interaction_state', 'label_text_input', 'length_unit',
    'max_relative_cube_screen_area', 'min_relative_cube_screen_area',
    'place_factor', 'render_time_multiplier', 'rescale_factor',
    'side_length', 'tolerance', 'world_position'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MeasurementCubeHandleRepresentation3D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MeasurementCubeHandleRepresentation3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['active_representation', 'adaptive_scaling', 'constrained',
            'handle_visibility', 'label_visibility', 'need_to_render',
            'picking_managed', 'selected_label_visibility', 'smooth_motion',
            'use_bounds', 'visibility'], [], ['display_position',
            'estimated_render_time', 'handle_size', 'interaction_state',
            'label_text_input', 'length_unit', 'max_relative_cube_screen_area',
            'min_relative_cube_screen_area', 'place_factor',
            'render_time_multiplier', 'rescale_factor', 'side_length',
            'tolerance', 'world_position']),
            title='Edit MeasurementCubeHandleRepresentation3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MeasurementCubeHandleRepresentation3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

