# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_in_place_filter import ImageInPlaceFilter


class ImageCursor3D(ImageInPlaceFilter):
    """
    ImageCursor3D - Paints a cursor on top of an image or volume.
    
    Superclass: ImageInPlaceFilter
    
    ImageCursor3D will draw a cursor on a 2d image or 3d volume.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImageCursor3D, obj, update, **traits)
    
    cursor_radius = traits.Int(5, enter_set=True, auto_set=False, desc=\
        """
        Sets/Gets the radius of the cursor. The radius determines how far
        the axis lines project out from the cursors center.
        """
    )

    def _cursor_radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCursorRadius,
                        self.cursor_radius)

    cursor_position = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        """
        
        """
    )

    def _cursor_position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCursorPosition,
                        self.cursor_position)

    cursor_value = traits.Float(255.0, enter_set=True, auto_set=False, desc=\
        """
        Sets/Gets what pixel value to draw the cursor in.
        """
    )

    def _cursor_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCursorValue,
                        self.cursor_value)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('global_warning_display', 'GetGlobalWarningDisplay'),
    ('cursor_position', 'GetCursorPosition'), ('abort_execute',
    'GetAbortExecute'), ('cursor_radius', 'GetCursorRadius'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'), ('cursor_value',
    'GetCursorValue'), ('reference_count', 'GetReferenceCount'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'cursor_position', 'cursor_radius',
    'cursor_value', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImageCursor3D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ImageCursor3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['cursor_position', 'cursor_radius', 'cursor_value']),
            title='Edit ImageCursor3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImageCursor3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

