# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_pad_filter import ImagePadFilter


class ImageConstantPad(ImagePadFilter):
    """
    ImageConstantPad - Makes image larger by padding with constant.
    
    Superclass: ImagePadFilter
    
    ImageConstantPad changes the image extent of its input. Any pixels
    outside of the original image extent are filled with a constant value
    (default is 0.0).
    
    @sa
    ImageWrapPad ImageMirrorPad
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImageConstantPad, obj, update, **traits)
    
    constant = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the pad value.
        """
    )

    def _constant_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConstant,
                        self.constant)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('constant', 'GetConstant'), ('output_whole_extent',
    'GetOutputWholeExtent'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('desired_bytes_per_piece', 'GetDesiredBytesPerPiece'), ('progress',
    'GetProgress'), ('number_of_threads', 'GetNumberOfThreads'),
    ('enable_smp', 'GetEnableSMP'), ('reference_count',
    'GetReferenceCount'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('abort_execute', 'GetAbortExecute'),
    ('output_number_of_scalar_components',
    'GetOutputNumberOfScalarComponents'), ('global_default_enable_smp',
    'GetGlobalDefaultEnableSMP'), ('split_mode', 'GetSplitMode'),
    ('minimum_piece_size', 'GetMinimumPieceSize'), ('progress_text',
    'GetProgressText'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'split_mode', 'constant',
    'desired_bytes_per_piece', 'enable_smp', 'global_default_enable_smp',
    'minimum_piece_size', 'number_of_threads',
    'output_number_of_scalar_components', 'output_whole_extent',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImageConstantPad, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ImageConstantPad properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['split_mode'], ['constant', 'desired_bytes_per_piece',
            'enable_smp', 'global_default_enable_smp', 'minimum_piece_size',
            'number_of_threads', 'output_number_of_scalar_components',
            'output_whole_extent']),
            title='Edit ImageConstantPad properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImageConstantPad properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

