# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.algorithm import Algorithm


class HyperTreeGridAlgorithm(Algorithm):
    """
    HyperTreeGridAlgorithm - Superclass for algorithms that produce a
    hyper tree grid as output
    
    Superclass: Algorithm
    
    HyperTreeGridAlgorithm is a base class for hyper tree grid
    algorithms. This class defaults with one input port and one output
    port; it must be modified by the concrete derived class if a
    different behavior is sought. In addition, this class provides a
    fill_output_port_info() method that, by default, specifies that the
    output is a data object; this must also be modified in concrete
    subclasses if needed.
    
    @par Thanks: This test was written by Philippe Pebay and Charles Law,
    Kitware 2012 This test was rewritten by Philippe Pebay, 2016 This
    work was supported by Commissariat a l'Energie Atomique (CEA/DIF)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeGridAlgorithm, obj, update, **traits)
    
    def _get_output(self):
        return wrap_vtk(self._vtk_obj.GetOutput())
    
    def _set_output(self, obj):
        old_val = self._get_output()
        self._wrap_call(self._vtk_obj.SetOutput, deref_vtk(obj))
        self.trait_property_changed('output', old_val, obj)
    output = traits.Property(_get_output, _set_output,
                             desc="Output of this source, i.e. the result of `get_output()`.")
    
    def get_output(self, idx=None):
        """
        V.get_output() -> DataObject
        C++: DataObject *GetOutput()
        V.get_output(int) -> DataObject
        C++: DataObject *GetOutput(int)
        Get the output data object for a port on this algorithm.
        """
        if idx is None:
            return wrap_vtk(self._vtk_obj.GetOutput())
        else:
            return wrap_vtk(self._vtk_obj.GetOutput(idx))

    def set_output(self, obj):
        """
        V.set_output(DataObject)
        C++: virtual void SetOutput(DataObject *)
        Get the output data object for a port on this algorithm.
        """
        old_val = self._get_output()
        self._wrap_call(self._vtk_obj.SetOutput, deref_vtk(obj))
        self.trait_property_changed('output', old_val, obj)

    def _get_hyper_tree_grid_output(self):
        return wrap_vtk(self._vtk_obj.GetHyperTreeGridOutput())
    hyper_tree_grid_output = traits.Property(_get_hyper_tree_grid_output, desc=\
        """
        Get the output as a hyper tree grid.
        """
    )

    def get_hyper_tree_grid_output(self, *args):
        """
        V.get_hyper_tree_grid_output() -> HyperTreeGrid
        C++: HyperTreeGrid *GetHyperTreeGridOutput()
        V.get_hyper_tree_grid_output(int) -> HyperTreeGrid
        C++: HyperTreeGrid *GetHyperTreeGridOutput(int)
        Get the output as a hyper tree grid.
        """
        ret = self._wrap_call(self._vtk_obj.GetHyperTreeGridOutput, *args)
        return wrap_vtk(ret)

    def _get_poly_data_output(self):
        return wrap_vtk(self._vtk_obj.GetPolyDataOutput())
    poly_data_output = traits.Property(_get_poly_data_output, desc=\
        """
        Get the output as a polygonal dataset.
        """
    )

    def get_poly_data_output(self, *args):
        """
        V.get_poly_data_output() -> PolyData
        C++: PolyData *GetPolyDataOutput()
        V.get_poly_data_output(int) -> PolyData
        C++: PolyData *GetPolyDataOutput(int)
        Get the output as a polygonal dataset.
        """
        ret = self._wrap_call(self._vtk_obj.GetPolyDataOutput, *args)
        return wrap_vtk(ret)

    def _get_unstructured_grid_output(self):
        return wrap_vtk(self._vtk_obj.GetUnstructuredGridOutput())
    unstructured_grid_output = traits.Property(_get_unstructured_grid_output, desc=\
        """
        Get the output as an unstructured grid.
        """
    )

    def get_unstructured_grid_output(self, *args):
        """
        V.get_unstructured_grid_output() -> UnstructuredGrid
        C++: UnstructuredGrid *GetUnstructuredGridOutput()
        V.get_unstructured_grid_output(int) -> UnstructuredGrid
        C++: UnstructuredGrid *GetUnstructuredGridOutput(int)
        Get the output as an unstructured grid.
        """
        ret = self._wrap_call(self._vtk_obj.GetUnstructuredGridOutput, *args)
        return wrap_vtk(ret)

    def add_input_data(self, *args):
        """
        V.add_input_data(DataObject)
        C++: void AddInputData(DataObject *)
        V.add_input_data(int, DataObject)
        C++: void AddInputData(int, DataObject *)
        Assign a data object as input. Note that this method does not
        establish a pipeline connection. Use add_input_connection() to
        setup a pipeline connection.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddInputData, *my_args)
        return ret

    def set_input_data(self, *args):
        """
        V.set_input_data(DataObject)
        C++: void SetInputData(DataObject *)
        V.set_input_data(int, DataObject)
        C++: void SetInputData(int, DataObject *)
        Assign a data object as input. Note that this method does not
        establish a pipeline connection. Use set_input_connection() to
        setup a pipeline connection.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputData, *my_args)
        return ret

    _updateable_traits_ = \
    (('progress_text', 'GetProgressText'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('release_data_flag',
    'GetReleaseDataFlag'), ('reference_count', 'GetReferenceCount'),
    ('debug', 'GetDebug'), ('progress', 'GetProgress'), ('abort_execute',
    'GetAbortExecute'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeGridAlgorithm, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeGridAlgorithm properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit HyperTreeGridAlgorithm properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeGridAlgorithm properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

