# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class ContourLoopExtraction(PolyDataAlgorithm):
    """
    ContourLoopExtraction - extract closed loops (polygons) from lines
    
    Superclass: PolyDataAlgorithm
    
    This filter takes an input consisting of lines and polylines and
    constructs polygons (i.e., closed loops) from them. It combines some
    of the capability of connectivity filters and the line stripper to
    produce manifold loops that are suitable for geometric operations.
    For example, the CookieCutter works well with this filter.
    
    Note that the input to this filter consists of points and line or
    polyline cells. All other topological types (verts, polygons,
    triangle strips) are ignored. The output of this filter is manifold
    polygons.
    
    @warning
    Although the loops are constructed in 3-space, a normal vector must
    be supplied to help select turns when multiple choices are possible.
    By default the normal vector is n={0,0,1} but may be user specified.
    Note also that some filters require that the loops are located in the
    z=constant or z=0 plane. Hence a transform filter of some sort may be
    necesssary to project the loops to a plane.
    
    @warning
    Note that lines that do not close in on themselves can be optionally
    forced closed. This occurs when for example, 2d contours end and
    begin at the boundaries of data. By forcing closure, the last point
    is joined to the first point. Note that there are different closure
    modes: 1) do not close (and hence reject the polygon); 2) close along
    grid boundaries (vertical or horizontal x and y lines); and 3) close
    all open loops.
    
    @warning
    Scalar thresholding can be enabled. If enabled, then only those loops
    with
    *any" scalar point data within the thresholded range are extracted.
    
    @warning
    Any detached lines forming degenerate loops of two points or less are
    discarded. Non-manifold junctions are broken into separate,
    independent loops.
    
    @sa
    CookieCutter FlyingEdges2D MarchingSquares FeatureEdges
    ConnectivityFilter PolyDataConnectivityFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkContourLoopExtraction, obj, update, **traits)
    
    scalar_thresholding = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off the extraction of loops based on scalar thresholding.
         Loops with scalar values in a specified range can be extracted.
        If no scalars are available from the input than this data member
        is ignored.
        """
    )

    def _scalar_thresholding_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalarThresholding,
                        self.scalar_thresholding_)

    loop_closure = traits.Trait('boundary',
    tvtk_base.TraitRevPrefixMap({'boundary': 1, 'off': 0, 'all': 2}), desc=\
        """
        Specify whether to close loops or not. All loops can be closed;
        boundary loops (x or y vertical or horizontal lines) can be
        closed (default); or all loops can be closed.
        """
    )

    def _loop_closure_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLoopClosure,
                        self.loop_closure_)

    normal = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 1.0), cols=3, desc=\
        """
        
        """
    )

    def _normal_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormal,
                        self.normal)

    scalar_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(0.0, 1.0), cols=2, desc=\
        """
        
        """
    )

    def _scalar_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalarRange,
                        self.scalar_range)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('progress_text', 'GetProgressText'), ('normal', 'GetNormal'),
    ('scalar_range', 'GetScalarRange'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('scalar_thresholding',
    'GetScalarThresholding'), ('debug', 'GetDebug'), ('loop_closure',
    'GetLoopClosure'), ('abort_execute', 'GetAbortExecute'),
    ('reference_count', 'GetReferenceCount'), ('progress', 'GetProgress'),
    ('release_data_flag', 'GetReleaseDataFlag'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'scalar_thresholding', 'loop_closure', 'normal',
    'progress_text', 'scalar_range'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ContourLoopExtraction, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ContourLoopExtraction properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['scalar_thresholding'], ['loop_closure'], ['normal',
            'scalar_range']),
            title='Edit ContourLoopExtraction properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ContourLoopExtraction properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

