# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set_surface_filter import DataSetSurfaceFilter


class AdaptiveDataSetSurfaceFilter(DataSetSurfaceFilter):
    """
    AdaptiveDataSetSurfaceFilter - Adaptively extract dataset surface
    
    Superclass: DataSetSurfaceFilter
    
    AdaptiveDataSetSurfaceFilter uses view and dataset properties to
    create the outside surface mesh with the minimum minimorum of facets
    @warning
    Only implemented currently for 2-dimensional HyperTreeGrid objects
    @sa
    HyperTreeGrid DataSetSurfaceFilter@par Thanks: This class was
    written by Guenole Harel and Jacques-Bernard Lekien, 2014 This class
    was rewritten by Philippe Pebay, 2016 This class was modified by
    Rogeli Grima, 2016 This work was supported by Commissariat a
    l'Energie Atomique (CEA/DIF)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAdaptiveDataSetSurfaceFilter, obj, update, **traits)
    
    def _get_renderer(self):
        return wrap_vtk(self._vtk_obj.GetRenderer())
    def _set_renderer(self, arg):
        old_val = self._get_renderer()
        self._wrap_call(self._vtk_obj.SetRenderer,
                        deref_vtk(arg))
        self.trait_property_changed('renderer', old_val, arg)
    renderer = traits.Property(_get_renderer, _set_renderer, desc=\
        """
        Set/Get the renderer attached to this adaptive surface extractor
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def set_scale(self, *args):
        """
        V.set_scale(float)
        C++: virtual void SetScale(double _arg)
        Set the scale factor
        """
        ret = self._wrap_call(self._vtk_obj.SetScale, *args)
        return ret

    _updateable_traits_ = \
    (('progress_text', 'GetProgressText'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('debug', 'GetDebug'),
    ('nonlinear_subdivision_level', 'GetNonlinearSubdivisionLevel'),
    ('pass_through_cell_ids', 'GetPassThroughCellIds'),
    ('piece_invariant', 'GetPieceInvariant'), ('pass_through_point_ids',
    'GetPassThroughPointIds'), ('progress', 'GetProgress'),
    ('reference_count', 'GetReferenceCount'), ('use_strips',
    'GetUseStrips'), ('original_point_ids_name',
    'GetOriginalPointIdsName'), ('release_data_flag',
    'GetReleaseDataFlag'), ('original_cell_ids_name',
    'GetOriginalCellIdsName'), ('abort_execute', 'GetAbortExecute'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'pass_through_cell_ids', 'pass_through_point_ids',
    'release_data_flag', 'use_strips', 'nonlinear_subdivision_level',
    'original_cell_ids_name', 'original_point_ids_name',
    'piece_invariant', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AdaptiveDataSetSurfaceFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AdaptiveDataSetSurfaceFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['pass_through_cell_ids', 'pass_through_point_ids',
            'use_strips'], [], ['nonlinear_subdivision_level',
            'original_cell_ids_name', 'original_point_ids_name',
            'piece_invariant']),
            title='Edit AdaptiveDataSetSurfaceFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AdaptiveDataSetSurfaceFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

