# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.hyper_tree_grid_algorithm import HyperTreeGridAlgorithm


class HyperTreeGridPlaneCutter(HyperTreeGridAlgorithm):
    """
    HyperTreeGridPlaneCutter - cut an hyper tree grid volume with a
    plane and generate a polygonal cut surface.
    
    Superclass: HyperTreeGridAlgorithm
    
    HyperTreeGridPlaneCutter is a filter that takes as input an hyper
    tree grid and a single plane and generates the polygonal data
    intersection surface. This cut is computed at the leaf cells of the
    hyper tree. It is left as an option to decide whether the cut should
    be computed over the original AMR mesh or over its dual; in the
    latter case, perfect connectivity (i.e., mesh conformity in the FE
    sense) is achieved at the cost of interpolation to the dual of the
    input AMR mesh, and therefore of missing intersection plane pieces
    near the primal boundary.
    
    @sa
    HyperTreeGrid HyperTreeGridAlgorithm
    
    @par Thanks: This class was written by Philippe Pebay on a idea of
    Guénolé Harel and Jacques-Bernard Lekien, 2016 This class was
    modified by Rogeli Grima Torres, 2016 This work was supported by
    Commissariat a l'Energie Atomique (CEA/DIF)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeGridPlaneCutter, obj, update, **traits)
    
    dual = tvtk_base.false_bool_trait(help=\
        """
        Set/Get whether output mesh should be computed on dual grid
        """
    )

    def _dual_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDual,
                        self.dual_)

    plane = traits.Array(enter_set=True, auto_set=False, shape=(4,), dtype="float", value=(0.0, 0.0, 0.0, 0.0), cols=3, help=\
        """
        
        """
    )

    def _plane_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPlane,
                        self.plane)

    _updateable_traits_ = \
    (('dual', 'GetDual'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('plane',
    'GetPlane'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'dual', 'global_warning_display',
    'release_data_flag', 'plane', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeGridPlaneCutter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeGridPlaneCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['dual'], [], ['plane']),
            title='Edit HyperTreeGridPlaneCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeGridPlaneCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

