# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.hyper_tree_grid_algorithm import HyperTreeGridAlgorithm


class HyperTreeGridCellCenters(HyperTreeGridAlgorithm):
    """
    HyperTreeGridCellCenters - generate points at center of hyper tree
    grid leaf cell centers.
    
    Superclass: HyperTreeGridAlgorithm
    
    HyperTreeGridCellCenters is a filter that takes as input an hyper
    tree grid and generates on output points at the center of the leaf
    cells in the hyper tree grid. These points can be used for placing
    glyphs (vtk_glyph3d) or labeling (vtk_labeled_data_mapper). The cell
    attributes will be associated with the points on output.
    
    @warning
    You can choose to generate just points or points and vertex cells.
    Vertex cells are drawn during rendering; points are not. Use the ivar
    vertex_cells to generate cells.
    
    @sa
    CellCenters HyperTreeGrid HyperTreeGridAlgorithm
    
    @par Thanks: This class was written by Guenole Harel and
    Jacques-Bernard Lekien 2014 This class was rewritten by Philippe
    Pebay, nex_gen Analytics 2017 This work was supported by Commissariat
    a l'Energie Atomique (CEA/DIF)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeGridCellCenters, obj, update, **traits)
    
    vertex_cells = tvtk_base.true_bool_trait(help=\
        """
        Enable/disable the generation of vertex cells. The default is
        Off.
        """
    )

    def _vertex_cells_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexCells,
                        self.vertex_cells)

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ('vertex_cells',)
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeGridCellCenters, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeGridCellCenters properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit HyperTreeGridCellCenters properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeGridCellCenters properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

