# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class SphereTree(Object):
    """
    SphereTree - class to build and traverse sphere trees
    
    Superclass: Object
    
    SphereTree is a helper class used to build and traverse sphere
    trees. Various types of trees can be constructed for different VTK
    dataset types, as well well as different approaches to organize the
    tree into hierarchies.
    
    Typically building a complete sphere tree consists of two parts: 1)
    creating spheres for each cell in the dataset, then 2) creating an
    organizing hierarchy. The structure of the hierarchy varies depending
    on the topological characteristics of the dataset.
    
    Once the tree is constructed, various geometric operations are
    available for quickly selecting cells based on sphere tree
    operations; for example, process all cells intersecting a plane
    (i.e., use the sphere tree to identify candidate cells for plane
    intersection).
    
    This class does not necessarily create optimal sphere trees because
    some of its requirements (fast build time, provide simple reference
    code, a single bounding sphere per cell, etc.) precludes optimal
    performance. It is also oriented to computing on cells versus the
    classic problem of collision detection for polygonal models. For more
    information you want to read Gareth Bradshaw's ph_d thesis "Bounding
    Volume Hierarchies for Level-of-Detail Collision Handling" which does
    a nice job of laying out the challenges and important algorithms
    relative to sphere trees and BVH (bounding volume hierarchies).
    
    @sa
    SphereTreeFilter PlaneCutter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSphereTree, obj, update, **traits)
    
    build_hierarchy = tvtk_base.true_bool_trait(help=\
        """
        Control whether the tree hierarchy is built. If not, then just
        cell spheres are created (one for each cell).
        """
    )

    def _build_hierarchy_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBuildHierarchy,
                        self.build_hierarchy_)

    resolution = traits.Trait(3, traits.Range(2, 10, enter_set=True, auto_set=False), help=\
        """
        Sphere tree creation requires gathering spheres into groups. The
        Resolution variable is a rough guide to the size of each group
        (the size different meanings depending on the type of data
        (structured versus unstructured). For example, in 3d structured
        data, blocks of resolution Resolution^3 are created. By default
        the Resolution is three.
        """
    )

    def _resolution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResolution,
                        self.resolution)

    def _get_data_set(self):
        return wrap_vtk(self._vtk_obj.GetDataSet())
    def _set_data_set(self, arg):
        old_val = self._get_data_set()
        self._wrap_call(self._vtk_obj.SetDataSet,
                        deref_vtk(arg))
        self.trait_property_changed('data_set', old_val, arg)
    data_set = traits.Property(_get_data_set, _set_data_set, help=\
        """
        Specify the dataset from which to build the sphere tree.
        """
    )

    max_level = traits.Trait(10, traits.Range(1, 20, enter_set=True, auto_set=False), help=\
        """
        Specify the maximum number of levels for the tree. By default,
        the number of levels is set to ten. If the number of levels is
        set to one or less, then no hierarchy is built (i.e., just the
        spheres for each cell are created). Note that the actual level of
        the tree may be less than this value depending on the number of
        cells and Resolution factor.
        """
    )

    def _max_level_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxLevel,
                        self.max_level)

    def _get_cell_spheres(self):
        return self._vtk_obj.GetCellSpheres()
    cell_spheres = traits.Property(_get_cell_spheres, help=\
        """
        Special methods to retrieve the sphere tree data. This is
        generally used for debugging or with filters like
        SphereTreeFilter. Both methods return an array of double*
        where four doubles represent a sphere (center + radius). In the
        first method a sphere per cell is returned. In the second method
        the user must also specify a level in the sphere tree (used to
        retrieve the hierarchy of the tree). Note that null pointers can
        be returned if the request is not consistent with the state of
        the sphere tree.
        """
    )

    def _get_number_of_levels(self):
        return self._vtk_obj.GetNumberOfLevels()
    number_of_levels = traits.Property(_get_number_of_levels, help=\
        """
        Get the current depth of the sphere tree. This value may change
        each time the sphere tree is built and the branching factor
        (i.e., resolution) changes. Note that after building the sphere
        tree there are [_0,this->_number_of_levels) defined levels.
        """
    )

    def get_tree_spheres(self, *args):
        """
        V.get_tree_spheres(int, int) -> (float, ...)
        C++: const double *GetTreeSpheres(int level,
            IdType &numSpheres)
        Special methods to retrieve the sphere tree data. This is
        generally used for debugging or with filters like
        SphereTreeFilter. Both methods return an array of double*
        where four doubles represent a sphere (center + radius). In the
        first method a sphere per cell is returned. In the second method
        the user must also specify a level in the sphere tree (used to
        retrieve the hierarchy of the tree). Note that null pointers can
        be returned if the request is not consistent with the state of
        the sphere tree.
        """
        ret = self._wrap_call(self._vtk_obj.GetTreeSpheres, *args)
        return ret

    def build(self, *args):
        """
        V.build()
        C++: void Build()
        V.build(DataSet)
        C++: void Build(DataSet *input)
        Build the sphere tree (if necessary) from the data set specified.
        The build time is recorded so the sphere tree will only build if
        something has changed. An alternative method is available to both
        set the dataset and then build the sphere tree.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Build, *my_args)
        return ret

    def select_line(self, *args):
        """
        V.select_line([float, float, float], [float, float, float], int)
            -> (int, ...)
        C++: const unsigned char *SelectLine(double origin[3],
            double ray[3], IdType &numSelected)
        V.select_line([float, float, float], [float, float, float],
            IdList)
        C++: void SelectLine(double origin[3], double ray[3],
            IdList *cellIds)
        Methods for cell selection based on a geometric query. Internally
        different methods are used depending on the dataset type. The
        array returned is set to non-zero for each cell that intersects
        the geometric entity. select_point marks all cells with a non-zero
        value that may contain a point. select_line marks all cells that
        may intersect an infinite line. select_plane marks all cells that
        may intersect with an infinite plane.
        """
        my_args = deref_array(args, [(['float', 'float', 'float'], ['float', 'float', 'float'], 'int'), (['float', 'float', 'float'], ['float', 'float', 'float'], 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.SelectLine, *my_args)
        return ret

    def select_plane(self, *args):
        """
        V.select_plane([float, float, float], [float, float, float], int)
            -> (int, ...)
        C++: const unsigned char *SelectPlane(double origin[3],
            double normal[3], IdType &numSelected)
        V.select_plane([float, float, float], [float, float, float],
            IdList)
        C++: void SelectPlane(double origin[3], double normal[3],
            IdList *cellIds)
        Methods for cell selection based on a geometric query. Internally
        different methods are used depending on the dataset type. The
        array returned is set to non-zero for each cell that intersects
        the geometric entity. select_point marks all cells with a non-zero
        value that may contain a point. select_line marks all cells that
        may intersect an infinite line. select_plane marks all cells that
        may intersect with an infinite plane.
        """
        my_args = deref_array(args, [(['float', 'float', 'float'], ['float', 'float', 'float'], 'int'), (['float', 'float', 'float'], ['float', 'float', 'float'], 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.SelectPlane, *my_args)
        return ret

    def select_point(self, *args):
        """
        V.select_point([float, float, float], int) -> (int, ...)
        C++: const unsigned char *SelectPoint(double point[3],
            IdType &numSelected)
        V.select_point([float, float, float], IdList)
        C++: void SelectPoint(double point[3], IdList *cellIds)
        Methods for cell selection based on a geometric query. Internally
        different methods are used depending on the dataset type. The
        array returned is set to non-zero for each cell that intersects
        the geometric entity. select_point marks all cells with a non-zero
        value that may contain a point. select_line marks all cells that
        may intersect an infinite line. select_plane marks all cells that
        may intersect with an infinite plane.
        """
        my_args = deref_array(args, [(['float', 'float', 'float'], 'int'), (['float', 'float', 'float'], 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.SelectPoint, *my_args)
        return ret

    _updateable_traits_ = \
    (('max_level', 'GetMaxLevel'), ('reference_count',
    'GetReferenceCount'), ('debug', 'GetDebug'), ('resolution',
    'GetResolution'), ('build_hierarchy', 'GetBuildHierarchy'),
    ('global_warning_display', 'GetGlobalWarningDisplay'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['build_hierarchy', 'debug', 'global_warning_display', 'max_level',
    'resolution'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SphereTree, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SphereTree properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['build_hierarchy'], [], ['max_level', 'resolution']),
            title='Edit SphereTree properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SphereTree properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

