# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.render_timer_log import RenderTimerLog


class OpenGLRenderTimerLog(RenderTimerLog):
    """
    OpenGLRenderTimerLog - open_gl2 override for RenderTimerLog.
    
    Superclass: RenderTimerLog
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLRenderTimerLog, obj, update, **traits)
    
    min_timer_pool_size = traits.Int(32, auto_set=False, enter_set=True, help=\
        """
        This implementations keeps a pool of RenderTimers around,
        recycling them to avoid constantly allocating/freeing them. The
        pool is sometimes trimmed to free up memory if the number of
        timers in the pool is much greater the the number of timers
        currently used. This setting controls the minimum number of
        timers that will be kept. More may be kept if they are being
        used, but the pool will never be trimmed below this amount.
        
        Default value is 32, but can be adjusted for specific use cases.
        """
    )

    def _min_timer_pool_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinTimerPoolSize,
                        self.min_timer_pool_size)

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('frame_limit', 'GetFrameLimit'),
    ('reference_count', 'GetReferenceCount'), ('min_timer_pool_size',
    'GetMinTimerPoolSize'), ('logging_enabled', 'GetLoggingEnabled'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'logging_enabled', 'frame_limit',
    'min_timer_pool_size'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLRenderTimerLog, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLRenderTimerLog properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['logging_enabled'], [], ['frame_limit',
            'min_timer_pool_size']),
            title='Edit OpenGLRenderTimerLog properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLRenderTimerLog properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

