# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.threaded_image_algorithm import ThreadedImageAlgorithm


class ImageIdealHighPass(ThreadedImageAlgorithm):
    """
    ImageIdealHighPass - Simple frequency domain band pass.
    
    Superclass: ThreadedImageAlgorithm
    
    This filter only works on an image after it has been converted to
    frequency domain by a ImageFFT filter.  A ImageRFFT filter can
    be used to convert the output back into the spatial domain.
    ImageIdealHighPass just sets a portion of the image to zero.  The
    sharp cutoff in the frequence domain produces ringing in the spatial
    domain. Input and Output must be doubles.  Dimensionality is set when
    the axes are set.  Defaults to 2d on X and Y axes.
    
    @sa
    ImageButterworthHighPass ImageIdealLowPass ImageFFT
    ImageRFFT
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImageIdealHighPass, obj, update, **traits)
    
    z_cut_off = traits.Float(1e+299, auto_set=False, enter_set=True, help=\
        """
        Set/Get the cutoff frequency for each axis. The values are
        specified in the order X, Y, Z, Time. Units: Cycles per world
        unit (as defined by the data spacing).
        """
    )

    def _z_cut_off_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetZCutOff,
                        self.z_cut_off)

    y_cut_off = traits.Float(1e+299, auto_set=False, enter_set=True, help=\
        """
        Set/Get the cutoff frequency for each axis. The values are
        specified in the order X, Y, Z, Time. Units: Cycles per world
        unit (as defined by the data spacing).
        """
    )

    def _y_cut_off_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetYCutOff,
                        self.y_cut_off)

    cut_off = traits.Array(auto_set=False, enter_set=True, shape=(3,), dtype="float", value=(1e+299, 1e+299, 1e+299), cols=3, help=\
        """
        
        """
    )

    def _cut_off_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCutOff,
                        self.cut_off)

    x_cut_off = traits.Float(1e+299, auto_set=False, enter_set=True, help=\
        """
        Set/Get the cutoff frequency for each axis. The values are
        specified in the order X, Y, Z, Time. Units: Cycles per world
        unit (as defined by the data spacing).
        """
    )

    def _x_cut_off_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetXCutOff,
                        self.x_cut_off)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            help="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('x_cut_off', 'GetXCutOff'), ('debug', 'GetDebug'), ('enable_smp',
    'GetEnableSMP'), ('minimum_piece_size', 'GetMinimumPieceSize'),
    ('z_cut_off', 'GetZCutOff'), ('y_cut_off', 'GetYCutOff'),
    ('global_default_enable_smp', 'GetGlobalDefaultEnableSMP'),
    ('progress', 'GetProgress'), ('reference_count', 'GetReferenceCount'),
    ('desired_bytes_per_piece', 'GetDesiredBytesPerPiece'),
    ('abort_execute', 'GetAbortExecute'), ('number_of_threads',
    'GetNumberOfThreads'), ('split_mode', 'GetSplitMode'), ('cut_off',
    'GetCutOff'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('progress_text', 'GetProgressText'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'split_mode', 'cut_off',
    'desired_bytes_per_piece', 'enable_smp', 'global_default_enable_smp',
    'minimum_piece_size', 'number_of_threads', 'progress_text',
    'x_cut_off', 'y_cut_off', 'z_cut_off'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImageIdealHighPass, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ImageIdealHighPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['split_mode'], ['cut_off', 'desired_bytes_per_piece',
            'enable_smp', 'global_default_enable_smp', 'minimum_piece_size',
            'number_of_threads', 'x_cut_off', 'y_cut_off', 'z_cut_off']),
            title='Edit ImageIdealHighPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImageIdealHighPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

