# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_transform import AbstractTransform


class GeoSphereTransform(AbstractTransform):
    """
    GeoSphereTransform - A transformation between long-lat-alt and
    rect coords
    
    Superclass: AbstractTransform
    
    the cartesian coordinate system is the following (if base_altitude is
    0),
    - the origin is at the center of the earth
    - the x axis goes from the origin to (longtitude=-90,latitude=0),
      intersection of equator and the meridian passing just east of
      Galapagos Islands
    - the y axis goes from the origin to the intersection of Greenwitch
      meridian and equator (longitude=0,latitude=0)
    - the z axis goes from the origin to the Geographic North Pole
      (latitude=90)
    - therefore the frame is right-handed.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGeoSphereTransform, obj, update, **traits)
    
    to_rectangular = tvtk_base.true_bool_trait(help=\
        """
        If on, this transform converts (long,lat,alt) triples to (x,y,z)
        as an offset from the center of the earth. Alt, x, y, and z are
        all be in meters. If off, the transform works in the reverse
        direction. Initial value is on.
        """
    )

    def _to_rectangular_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetToRectangular,
                        self.to_rectangular_)

    base_altitude = traits.Float(0.0, auto_set=False, enter_set=True, help=\
        """
        The base altitude to transform coordinates to. This can be useful
        for transforming lines just above the earth's surface. Default is
        0.
        """
    )

    def _base_altitude_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBaseAltitude,
                        self.base_altitude)

    _updateable_traits_ = \
    (('to_rectangular', 'GetToRectangular'), ('base_altitude',
    'GetBaseAltitude'), ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'to_rectangular',
    'base_altitude'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GeoSphereTransform, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GeoSphereTransform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['to_rectangular'], [], ['base_altitude']),
            title='Edit GeoSphereTransform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GeoSphereTransform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

