# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class TriangleMeshPointNormals(PolyDataAlgorithm):
    """
    TriangleMeshPointNormals - compute point normals for triangle mesh
    
    Superclass: PolyDataAlgorithm
    
    TriangleMeshPointNormals is a filter that computes point normals
    for a triangle mesh to enable high-performance rendering. It is a
    fast-path version of the PolyDataNormals filter in order to be
    able to compute normals for triangle meshes deforming rapidly.
    
    The computed normals (a FloatArray) are set to be the active
    normals (using set_normals()) of the point_data. The array name is
    "Normals", so they can be retrieved either with
    `output->_get_point_data()->_get_normals()` or with
    `output->_get_point_data()->_get_array("_normals")`.
    
    The algorithm works by determining normals for each triangle and
    adding these vectors to the triangle points. The resulting vectors at
    each point are then normalized.
    
    @warning
    Normals are computed only for triangular polygons: the filter can not
    handle meshes with other types of cells (Verts, Lines, Strips) or
    Polys with the wrong number of components (not equal to 3).
    
    @warning
    Unlike the PolyDataNormals filter, this filter does not apply any
    splitting nor checks for cell orientation consistency in order to
    speed up the computation. Moreover, normals are not calculated the
    exact same way as the PolyDataNormals filter since the triangle
    normals are not normalized before being added to the point normals:
    those cell normals are therefore weighted by the triangle area. This
    is not more nor less correct than normalizing them before adding
    them, but it is much faster.
    
    @sa
    If you do not need to do high-performance rendering, you should use
    PolyDataNormals if your mesh is not only triangular, if you need
    to split vertices at sharp edges, or if you need to check that the
    cell orientations are consistent to flip inverted normals.
    
    @sa
    If you still need high-performance rendering but your input polydata
    is not a triangular mesh and/or does not have consistent cell
    orientations (causing inverted normals), you can still use this
    filter by using TriangleFilter and/or CleanPolyData
    respectively beforehand. If your mesh is deforming rapidly, you
    should be deforming the output mesh of those two filters instead in
    order to only run them once.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTriangleMeshPointNormals, obj, update, **traits)
    
    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            help="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(TriangleMeshPointNormals, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit TriangleMeshPointNormals properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit TriangleMeshPointNormals properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit TriangleMeshPointNormals properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

