# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class AbstractContextBufferId(Object):
    """
    AbstractContextBufferId - 2d array of ids, used for picking.
    
    Superclass: Object
    
    An 2d array where each element is the id of an entity drawn at the
    given pixel. The access is not specified in this class. The
    effective/concrete subclass ContextBufferId stores the whole
    buffer in RAM. The access to a value is fast and independent of the
    open_gl. However it requires to first fill the whole buffer by
    transferring the buffer generated by open_gl from the VRAM to the RAM.
    It is inefficient if the context of the scene changes during
    interaction.
    
    The effective/concrete subclass OpenGLContextBufferId keeps the
    buffer id on the VRAM in a texture image. The access to a value is
    slower than a simple read access to an array but it does not require
    a large transfer of data from the VRAM to the RAM.
    
    @sa
    ContextBufferId, OpenGLContextBufferId
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAbstractContextBufferId, obj, update, **traits)
    
    def _get_context(self):
        return wrap_vtk(self._vtk_obj.GetContext())
    def _set_context(self, arg):
        old_val = self._get_context()
        self._wrap_call(self._vtk_obj.SetContext,
                        deref_vtk(arg))
        self.trait_property_changed('context', old_val, arg)
    context = traits.Property(_get_context, _set_context, help=\
        """
        Set/Get the open_gl context owning the texture object resource.
        """
    )

    height = traits.Int(0, enter_set=True, auto_set=False, help=\
        """
        Set the number of rows. Initial value is 0.
        """
    )

    def _height_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHeight,
                        self.height)

    width = traits.Int(0, enter_set=True, auto_set=False, help=\
        """
        Set the number of columns. Initial value is 0.
        """
    )

    def _width_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWidth,
                        self.width)

    def get_picked_item(self, *args):
        """
        V.get_picked_item(int, int) -> int
        C++: virtual IdType GetPickedItem(int x, int y)
        Return item under abscissa x and ordinate y. Abscissa go from
        left to right. Ordinate go from bottom to top. The return value
        is -1 if there is no item.
        \pre is_allocated: is_allocated()
        \post valid_result: result>=-1
        """
        ret = self._wrap_call(self._vtk_obj.GetPickedItem, *args)
        return ret

    def allocate(self):
        """
        V.allocate()
        C++: virtual void Allocate()
        Allocate the memory for at least Width*Height elements.
        \pre positive_width: get_width()>_0
        \pre positive_height: get_height()>_0
        """
        ret = self._vtk_obj.Allocate()
        return ret
        

    def is_allocated(self):
        """
        V.is_allocated() -> bool
        C++: virtual bool IsAllocated()
        Tell if the buffer has been allocated.
        """
        ret = self._vtk_obj.IsAllocated()
        return ret
        

    def is_supported(self):
        """
        V.is_supported() -> bool
        C++: virtual bool IsSupported()
        Returns if the context supports the required extensions.
        \pre context_is_set: this->_get_context()!=_0
        """
        ret = self._vtk_obj.IsSupported()
        return ret
        

    def release_graphics_resources(self):
        """
        V.release_graphics_resources()
        C++: virtual void ReleaseGraphicsResources()
        Release any graphics resources that are being consumed by this
        object. Default implementation is empty.
        """
        ret = self._vtk_obj.ReleaseGraphicsResources()
        return ret
        

    def set_values(self, *args):
        """
        V.set_values(int, int)
        C++: virtual void SetValues(int srcXmin, int srcYmin)
        Copy the contents of the current read buffer to the internal
        structure starting at lower left corner of the framebuffer
        (src_xmin,src_ymin).
        \pre is_allocated: this->_is_allocated()
        """
        ret = self._wrap_call(self._vtk_obj.SetValues, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('height', 'GetHeight'), ('width',
    'GetWidth'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'height', 'width'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AbstractContextBufferId, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AbstractContextBufferId properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['height', 'width']),
            title='Edit AbstractContextBufferId properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AbstractContextBufferId properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

