# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.multi_time_step_algorithm import MultiTimeStepAlgorithm


class TemporalArrayOperatorFilter(MultiTimeStepAlgorithm):
    """
    TemporalArrayOperatorFilter - perform simple mathematical
    operation on a data array at different time
    
    Superclass: MultiTimeStepAlgorithm
    
    This filter computes a simple operation between two time steps of one
    data array.
    
    @sa
    ArrayCalulator
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTemporalArrayOperatorFilter, obj, update, **traits)
    
    second_time_step_index = traits.Int(0, enter_set=True, auto_set=False, help=\
        """
        Set/Get the second time step.
        """
    )

    def _second_time_step_index_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSecondTimeStepIndex,
                        self.second_time_step_index)

    first_time_step_index = traits.Int(0, enter_set=True, auto_set=False, help=\
        """
        Set/Get the first time step.
        """
    )

    def _first_time_step_index_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFirstTimeStepIndex,
                        self.first_time_step_index)

    operator = traits.Int(0, enter_set=True, auto_set=False, help=\
        """
        Set/Get the operator to apply. Default is ADD (0).
        """
    )

    def _operator_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOperator,
                        self.operator)

    output_array_name_suffix = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), help=\
        """
        Set/Get the suffix to be append to the output array name.
        If not specified, output will be suffixed with '_' and the
        operation type (eg. myarrayname_add).
        """
    )

    def _output_array_name_suffix_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputArrayNameSuffix,
                        self.output_array_name_suffix)

    _updateable_traits_ = \
    (('second_time_step_index', 'GetSecondTimeStepIndex'),
    ('first_time_step_index', 'GetFirstTimeStepIndex'), ('operator',
    'GetOperator'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('progress',
    'GetProgress'), ('output_array_name_suffix',
    'GetOutputArrayNameSuffix'), ('progress_text', 'GetProgressText'),
    ('debug', 'GetDebug'), ('abort_execute', 'GetAbortExecute'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'first_time_step_index', 'operator',
    'output_array_name_suffix', 'progress_text',
    'second_time_step_index'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(TemporalArrayOperatorFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit TemporalArrayOperatorFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['first_time_step_index', 'operator',
            'output_array_name_suffix', 'second_time_step_index']),
            title='Edit TemporalArrayOperatorFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit TemporalArrayOperatorFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

