# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.exporter import Exporter


class SVGExporter(Exporter):
    """
    SVGExporter - Exports Context2D scenes to SVG.
    
    Superclass: Exporter
    
    This exporter draws context_2d scenes into a SVG file.
    
    Limitations:
    - The Nearest/Linear texture properties are ignored, since SVG
      doesn't provide any reliable control over interpolation.
    - Embedded fonts are experimental and poorly tested. Viewer support
      is lacking at the time of writing, hence the feature is largely
      useless. By default, fonts are not embedded since they're basically
    useless bloat. (this option is not exposed in SVGExporter).
    - text_as_path is enabled by default, since viewers differ wildly in
      how they handle text objects (eg. Inkscape renders at expected
      size, but webkit is way too big).
    - Pattern fills and markers are not shown on some viewers, e.g. KDE's
    okular (Webkit seems to work, though).
    - Clipping seems to be broken in most viewers. Webkit is buggy and
      forces the clip coordinates to object_bounding_box, even when
      explicitly set to user_space_on_use.
    - Many viewers anti-alias the output, leaving thin outlines around
      the triangles that make up larger polygons. This is a viewer issue
      and there not much we can do about it from the VTK side of things
      (and most viewers don't seem to have an antialiasing toggle,
      either...).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSVGExporter, obj, update, **traits)
    
    text_as_path = tvtk_base.true_bool_trait(help=\
        """
        
        """
    )

    def _text_as_path_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTextAsPath,
                        self.text_as_path_)

    draw_background = tvtk_base.true_bool_trait(help=\
        """
        
        """
    )

    def _draw_background_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDrawBackground,
                        self.draw_background_)

    subdivision_threshold = traits.Float(1.0, enter_set=True, auto_set=False, help=\
        """
        
        """
    )

    def _subdivision_threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSubdivisionThreshold,
                        self.subdivision_threshold)

    description = traits.String('VTK Exported Scene', enter_set=True, auto_set=False, help=\
        """
        
        """
    )

    def _description_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDescription,
                        self.description)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    def _set_input(self, arg):
        old_val = self._get_input()
        self._wrap_call(self._vtk_obj.SetInput,
                        deref_vtk(arg))
        self.trait_property_changed('input', old_val, arg)
    input = traits.Property(_get_input, _set_input, help=\
        """
        These methods are provided for backward compatibility. Will
        disappear soon.
        """
    )

    file_name = tvtk_base.vtk_file_name("", help=\
        """
        
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    title = traits.String('VTK Exported Scene', enter_set=True, auto_set=False, help=\
        """
        
        """
    )

    def _title_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTitle,
                        self.title)

    _updateable_traits_ = \
    (('global_warning_display', 'GetGlobalWarningDisplay'),
    ('draw_background', 'GetDrawBackground'), ('subdivision_threshold',
    'GetSubdivisionThreshold'), ('description', 'GetDescription'),
    ('text_as_path', 'GetTextAsPath'), ('debug', 'GetDebug'), ('title',
    'GetTitle'), ('reference_count', 'GetReferenceCount'), ('file_name',
    'GetFileName'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'draw_background', 'global_warning_display',
    'text_as_path', 'description', 'file_name', 'subdivision_threshold',
    'title'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SVGExporter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SVGExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['draw_background', 'text_as_path'], [], ['description',
            'file_name', 'subdivision_threshold', 'title']),
            title='Edit SVGExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SVGExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

