# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_writer import DataWriter


class StructuredGridWriter(DataWriter):
    """
    StructuredGridWriter - write vtk structured grid data file
    
    Superclass: DataWriter
    
    StructuredGridWriter is a source object that writes ASCII or
    binary structured grid data files in vtk format. See text for format
    details.
    
    @warning
    Binary files written on one system may not be readable on other
    systems.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkStructuredGridWriter, obj, update, **traits)
    
    write_extent = tvtk_base.false_bool_trait(help=\
        """
        When write_extent is on, StructuredPointsWriter writes data
        extent in the output file. Otherwise, it writes dimensions. The
        only time this option is useful is when the extents do not start
        at (0, 0, 0). This is an options to support writing of older
        formats while still using a newer VTK.
        """
    )

    def _write_extent_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWriteExtent,
                        self.write_extent_)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            help="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> StructuredGrid
        C++: StructuredGrid *GetInput()
        V.get_input(int) -> StructuredGrid
        C++: StructuredGrid *GetInput(int port)
        Get the input to this writer.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('edge_flags_name', 'GetEdgeFlagsName'), ('tensors_name',
    'GetTensorsName'), ('field_data_name', 'GetFieldDataName'),
    ('progress_text', 'GetProgressText'), ('debug', 'GetDebug'),
    ('t_coords_name', 'GetTCoordsName'), ('abort_execute',
    'GetAbortExecute'), ('reference_count', 'GetReferenceCount'),
    ('normals_name', 'GetNormalsName'), ('write_array_meta_data',
    'GetWriteArrayMetaData'), ('header', 'GetHeader'), ('file_name',
    'GetFileName'), ('pedigree_ids_name', 'GetPedigreeIdsName'),
    ('progress', 'GetProgress'), ('file_type', 'GetFileType'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('release_data_flag', 'GetReleaseDataFlag'),
    ('write_to_output_string', 'GetWriteToOutputString'), ('vectors_name',
    'GetVectorsName'), ('scalars_name', 'GetScalarsName'),
    ('global_ids_name', 'GetGlobalIdsName'), ('lookup_table_name',
    'GetLookupTableName'), ('write_extent', 'GetWriteExtent'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'write_array_meta_data', 'write_extent',
    'write_to_output_string', 'file_type', 'edge_flags_name',
    'field_data_name', 'file_name', 'global_ids_name', 'header',
    'lookup_table_name', 'normals_name', 'pedigree_ids_name',
    'progress_text', 'scalars_name', 't_coords_name', 'tensors_name',
    'vectors_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(StructuredGridWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit StructuredGridWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['write_array_meta_data', 'write_extent',
            'write_to_output_string'], ['file_type'], ['edge_flags_name',
            'field_data_name', 'file_name', 'global_ids_name', 'header',
            'lookup_table_name', 'normals_name', 'pedigree_ids_name',
            'scalars_name', 't_coords_name', 'tensors_name', 'vectors_name']),
            title='Edit StructuredGridWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit StructuredGridWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

