# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class SphereTreeFilter(PolyDataAlgorithm):
    """
    SphereTreeFilter - represent a sphere tree as PolyData
    
    Superclass: PolyDataAlgorithm
    
    SphereTreeFilter is a filter that produces a PolyData
    representation of a sphere tree (vtk_sphere_tree). Basically it
    generates a point, a scalar radius, and tree level number for the
    cell spheres and/or the different levels in the tree hierarchy
    (assuming that the hierarchy is built). The output can be glyphed
    using a filter like Glyph3D to actually visualize the sphere tree.
    The primary use of this class is for visualization of sphere trees,
    and debugging the construction and use of sphere trees.
    
    Additional capabilities include production of candidate spheres based
    on geometric queries. For example, queries based on a point, infinite
    line, and infinite plane are possible.
    
    Note that this class may create a sphere tree, and then build it, for
    the input dataset to this filter (if no sphere tree is provided). If
    the user specifies a sphere tree, then the specified sphere tree is
    used. Thus the input to the filter is optional. Consequently this
    filter can act like a source, or as a filter in a pipeline.
    
    @sa
    SphereTree PlaneCutter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSphereTreeFilter, obj, update, **traits)
    
    tree_hierarchy = tvtk_base.true_bool_trait(help=\
        """
        Enable or disable the building and generation of the sphere tree
        hierarchy. The hierarchy represents different levels in the tree
        and enables rapid traversal of the tree.
        """
    )

    def _tree_hierarchy_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTreeHierarchy,
                        self.tree_hierarchy_)

    extraction_mode = traits.Trait('levels',
    tvtk_base.TraitRevPrefixMap({'plane': 3, 'point': 1, 'line': 2, 'levels': 0}), help=\
        """
        Specify what information this filter is to extract from the
        sphere tree. Options include: spheres that make up one or more
        levels; spheres that intersect a specified plane; spheres that
        intersect a specified line; and spheres that intersect a
        specified point. What is extracted are sphere centers, a radius,
        and an optional level. By default the specified levels are
        extracted.
        """
    )

    def _extraction_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtractionMode,
                        self.extraction_mode_)

    normal = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 1.0), cols=3, help=\
        """
        
        """
    )

    def _normal_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormal,
                        self.normal)

    level = traits.Trait(-1, traits.Range(-1, 32767, enter_set=True, auto_set=False), help=\
        """
        Specify the level of the tree to extract (used when
        extraction_mode is set to Levels). A value of (-1) means all
        levels. Note that level 0 is the root of the sphere tree. By
        default all levels are extracted. Note that if tree_hierarchy is
        off, then it is only possible to extract leaf spheres (i.e.,
        spheres for each cell of the associated dataset).
        """
    )

    def _level_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLevel,
                        self.level)

    def _get_sphere_tree(self):
        return wrap_vtk(self._vtk_obj.GetSphereTree())
    def _set_sphere_tree(self, arg):
        old_val = self._get_sphere_tree()
        self._wrap_call(self._vtk_obj.SetSphereTree,
                        deref_vtk(arg))
        self.trait_property_changed('sphere_tree', old_val, arg)
    sphere_tree = traits.Property(_get_sphere_tree, _set_sphere_tree, help=\
        """
        Specify and retrieve the sphere tree.
        """
    )

    ray = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(1.0, 0.0, 0.0), cols=3, help=\
        """
        
        """
    )

    def _ray_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRay,
                        self.ray)

    point = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, help=\
        """
        
        """
    )

    def _point_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPoint,
                        self.point)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            help="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('progress', 'GetProgress'), ('level', 'GetLevel'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('tree_hierarchy',
    'GetTreeHierarchy'), ('progress_text', 'GetProgressText'), ('debug',
    'GetDebug'), ('normal', 'GetNormal'), ('abort_execute',
    'GetAbortExecute'), ('reference_count', 'GetReferenceCount'), ('ray',
    'GetRay'), ('point', 'GetPoint'), ('extraction_mode',
    'GetExtractionMode'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'tree_hierarchy', 'extraction_mode', 'level',
    'normal', 'point', 'progress_text', 'ray'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SphereTreeFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SphereTreeFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['tree_hierarchy'], ['extraction_mode'], ['level', 'normal',
            'point', 'ray']),
            title='Edit SphereTreeFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SphereTreeFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

