# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class PythonInterpreter(Object):
    """
    PythonInterpreter - wrapper for an embedded Python interpreter.
    
    Superclass: Object
    
    PythonInterpreter only offers static methods. However, there may
    be need to register callbacks to call after the Python interpreter is
    initialized and before the interpreter is finalized. One can register
    observers for Command:EnterEvent and Command::ExitEvent to a
    local instance of PythonInterpreter. PythonInterpreter keeps
    tracks of all instances and invokes those events on all instances at
    appropriate times.
    
    Same is true for obtaining outputs/errors generated by Python.
    Command::ErrorEvent and Command::SetOutputEvent will be fired
    with calldata being const char* to the messages. Errors and output
    messages will also be forwarded to the OutputWindow singleton (via
    `vtk_output_window_display_error_text` and `vtk_output_window_display_text`
    calls). Changing the output window temporarily (e.g. using a
    StringOutputWindow) is another way of capturing messages generated
    through Python scripts.
    
    To capture stdin, especially for non-terminal applications, set
    capture_stdin to true. In that case Command::UpdateEvent will be
    fired with the calldata being a reference to a StdString that
    should be filled in with the text to be passed in as the input.
    
    A few of the methods on this class implicitly call
    PythonInterpreter::Initialize() to ensure Python is initialized
    viz. PythonInterpreter::PyMain() and
    PythonInterpreter::RunSimpleString(). These implicit
    initialization always calls PythonInterpreter::Initialize(1). If
    that's not what is expected, ensure that you call
    PythonInterpreter::Initialize(0) before calling such methods.
    Refer to py__initialize_ex() documentation for details on the
    differences between the two.
    
    Notes on calling Initialize/Finalize multiple times: Although
    applications are free to call Initialize/Finalize pairs multiple
    times, there are subtle differences between the first Initialize and
    subsequence Initialize calls after Finalize especially when
    concerning with imported modules. Refer to Python docs for details.
    In short, modules like numpy don't continue to work after a
    re-initialize. Hence use it with caution.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPythonInterpreter, obj, update, **traits)
    
    capture_stdin = traits.Bool(False, enter_set=True, auto_set=False, help=\
        """
        To capture stdin, especially for non-terminal applications, set
        capture_stdin to true. In that case Command::UpdateEvent will
        be fired with the calldata being a reference to a StdString
        that should be filled in with the text to be passed in as the
        input.
        """
    )

    def _capture_stdin_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCaptureStdin,
                        self.capture_stdin)

    def finalize(self):
        """
        V.finalize()
        C++: static void Finalize()
        Call this method to finalize Python. This has no effect if Python
        hasn't been initialized already.
        """
        ret = self._vtk_obj.Finalize()
        return ret
        

    def initialize(self, *args):
        """
        V.initialize(int) -> bool
        C++: static bool Initialize(int initsigs=1)
        Call this method to initialize Python. This has no effect if
        Python is already initialized. Returns true if Python was
        initialized by this call, or false if Python was already
        initialized. Although, one can call Initialize()/Finalize() pair
        multiple times, Python documentation warns that "Some extensions
        may not work properly if their initialization routine is called
        more than once; this can happen if an application calls
        py__initialize_ex() and Py_Finalize() more than once."
        """
        ret = self._wrap_call(self._vtk_obj.Initialize, *args)
        return ret

    def is_initialized(self):
        """
        V.is_initialized() -> bool
        C++: static bool IsInitialized()
        Returns true is Python is initialized.
        """
        ret = self._vtk_obj.IsInitialized()
        return ret
        

    def prepend_python_path(self, *args):
        """
        V.prepend_python_path(string)
        C++: static void PrependPythonPath(const char *)
        Prepends the path to the sys.path variable. If Python has been
        initialized, this call will update the sys.path variable
        otherwise the same will be done once Python has been initialized.
        The paths added are saved so that if Python is initialized again
        (by calls to Initialize()), then these paths will be re-added.
        """
        ret = self._wrap_call(self._vtk_obj.PrependPythonPath, *args)
        return ret

    def run_simple_string(self, *args):
        """
        V.run_simple_string(string) -> int
        C++: static int RunSimpleString(const char *script)
        Developers are free to call Python C API directly. This
        convenience method is provided to overcome an issue with the
        Python interpreter with handling of DOS line endings. This will
        initialize Python if not already initialized. Returns 0 on
        success or -1 if a python exception was raised.
        """
        ret = self._wrap_call(self._vtk_obj.RunSimpleString, *args)
        return ret

    def set_program_name(self, *args):
        """
        V.set_program_name(string)
        C++: static void SetProgramName(const char *programname)
        Set the program name. This must be called before the first
        Initialize() call. If called afterwords, this will raise a
        warning.
        """
        ret = self._wrap_call(self._vtk_obj.SetProgramName, *args)
        return ret

    _updateable_traits_ = \
    (('capture_stdin', 'GetCaptureStdin'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'capture_stdin'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PythonInterpreter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PythonInterpreter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['capture_stdin']),
            title='Edit PythonInterpreter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PythonInterpreter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

