# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class LoopBooleanPolyDataFilter(PolyDataAlgorithm):
    """
    LoopBooleanPolyDataFilter - Computes the boundary of the union,
    intersection, or difference volume computed from the volumes defined
    by two input surfaces.
    
    Superclass: PolyDataAlgorithm
    
    The two surfaces do not need to be manifold, but if they are not,
    unexpected results may be obtained. The resulting surface is
    available in the first output of the filter. The second output
    contains a set of polylines that represent the intersection between
    the two input surfaces. The filter uses
    IntersectionPolyDataFilter. Must have information about the cells
    on mesh that the intersection lines touch. Filter assumes this
    information is given. The output result will have data about the
    Original Surface, boundary_points, Boundary Cells, Free Edges, and Bad
    Triangles
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLoopBooleanPolyDataFilter, obj, update, **traits)
    
    no_intersection_output = tvtk_base.true_bool_trait(help=\
        """
        ONLY USED IF NO INTERSECTION BETWEEN SURFACES Variable to
        determine what is output if no intersection occurs. 0 = neither
        (default), 1 = first, 2 = second, 3 = both
        """
    )

    def _no_intersection_output_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNoIntersectionOutput,
                        self.no_intersection_output_)

    operation = traits.Trait('union',
    tvtk_base.TraitRevPrefixMap({'difference': 2, 'intersection': 1, 'union': 0}), help=\
        """
        Set the boolean operation to perform. Defaults to union.
        """
    )

    def _operation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOperation,
                        self.operation_)

    tolerance = traits.Float(1e-06, enter_set=True, auto_set=False, help=\
        """
        Set the tolerance for geometric tests
        """
    )

    def _tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTolerance,
                        self.tolerance)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            help="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_number_of_intersection_lines(self):
        return self._vtk_obj.GetNumberOfIntersectionLines()
    number_of_intersection_lines = traits.Property(_get_number_of_intersection_lines, help=\
        """
        Integer describing the number of intersection points and lines
        """
    )

    def _get_number_of_intersection_points(self):
        return self._vtk_obj.GetNumberOfIntersectionPoints()
    number_of_intersection_points = traits.Property(_get_number_of_intersection_points, help=\
        """
        Integer describing the number of intersection points and lines
        """
    )

    def _get_status(self):
        return self._vtk_obj.GetStatus()
    status = traits.Property(_get_status, help=\
        """
        Check the status of the filter after update. If the status is
        zero, there was an error in the operation. If status is one,
        everything went smoothly
        """
    )

    _updateable_traits_ = \
    (('progress_text', 'GetProgressText'), ('no_intersection_output',
    'GetNoIntersectionOutput'), ('progress', 'GetProgress'),
    ('abort_execute', 'GetAbortExecute'), ('reference_count',
    'GetReferenceCount'), ('tolerance', 'GetTolerance'), ('operation',
    'GetOperation'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'no_intersection_output', 'release_data_flag', 'operation',
    'progress_text', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(LoopBooleanPolyDataFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit LoopBooleanPolyDataFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['no_intersection_output'], ['operation'], ['tolerance']),
            title='Edit LoopBooleanPolyDataFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit LoopBooleanPolyDataFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

