# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class LinearExtrusionFilter(PolyDataAlgorithm):
    """
    LinearExtrusionFilter - sweep polygonal data creating a "skirt"
    from free edges and lines, and lines from vertices
    
    Superclass: PolyDataAlgorithm
    
    LinearExtrusionFilter is a modeling filter. It takes polygonal
    data as input and generates polygonal data on output. The input
    dataset is swept according to some extrusion function and creates new
    polygonal primitives. These primitives form a "skirt" or swept
    surface. For example, sweeping a line results in a quadrilateral, and
    sweeping a triangle creates a "wedge".
    
    There are a number of control parameters for this filter. You can
    control whether the sweep of a 2d object (i.e., polygon or triangle
    strip) is capped with the generating geometry via the "Capping" ivar.
    Also, you can extrude in the direction of a user specified vector,
    towards a point, or in the direction of vertex normals (normals must
    be provided - use PolyDataNormals if necessary). The amount of
    extrusion is controlled by the "_scale_factor" instance variable.
    
    The skirt is generated by locating certain topological features. Free
    edges (edges of polygons or triangle strips only used by one polygon
    or triangle strips) generate surfaces. This is true also of lines or
    polylines. Vertices generate lines.
    
    This filter can be used to create 3d fonts, 3d irregular bar charts,
    or to model 2 1/_2d objects like punched plates. It also can be used
    to create solid objects from 2d polygonal meshes.
    
    @warning
    Some polygonal objects have no free edges (e.g., sphere). When swept,
    this will result in two separate surfaces if capping is on, or no
    surface if capping is off.
    
    @sa
    RotationalExtrusionFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLinearExtrusionFilter, obj, update, **traits)
    
    capping = tvtk_base.true_bool_trait(help=\
        """
        Turn on/off the capping of the skirt.
        """
    )

    def _capping_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCapping,
                        self.capping_)

    extrusion_type = traits.Trait('normal_extrusion',
    tvtk_base.TraitRevPrefixMap({'vector_extrusion': 1, 'point_extrusion': 3, 'normal_extrusion': 2}), help=\
        """
        Set/Get the type of extrusion.
        """
    )

    def _extrusion_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtrusionType,
                        self.extrusion_type_)

    extrusion_point = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, help=\
        """
        
        """
    )

    def _extrusion_point_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtrusionPoint,
                        self.extrusion_point)

    vector = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 1.0), cols=3, help=\
        """
        
        """
    )

    def _vector_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVector,
                        self.vector)

    scale_factor = traits.Float(1.0, enter_set=True, auto_set=False, help=\
        """
        Set/Get extrusion scale factor,
        """
    )

    def _scale_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScaleFactor,
                        self.scale_factor)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            help="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('progress', 'GetProgress'), ('capping', 'GetCapping'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('extrusion_point',
    'GetExtrusionPoint'), ('progress_text', 'GetProgressText'), ('debug',
    'GetDebug'), ('extrusion_type', 'GetExtrusionType'), ('abort_execute',
    'GetAbortExecute'), ('reference_count', 'GetReferenceCount'),
    ('scale_factor', 'GetScaleFactor'), ('vector', 'GetVector'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'capping', 'debug', 'global_warning_display',
    'release_data_flag', 'extrusion_type', 'extrusion_point',
    'progress_text', 'scale_factor', 'vector'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(LinearExtrusionFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit LinearExtrusionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['capping'], ['extrusion_type'], ['extrusion_point',
            'scale_factor', 'vector']),
            title='Edit LinearExtrusionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit LinearExtrusionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

