# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.hyper_tree_grid_algorithm import HyperTreeGridAlgorithm


class HyperTreeGridAxisCut(HyperTreeGridAlgorithm):
    """
    HyperTreeGridAxisCut - Axis aligned hyper tree grid cut
    
    Superclass: HyperTreeGridAlgorithm
    
    Cut an hyper tree grid along an axis aligned plane and output a hyper
    tree grid lower dimensionality. Only works for 3d grids as inputs
    
    NB: This new (2014-16) version of the class is not to be confused
    with earlier (2012-13) version that produced a PolyData output
    composed of disjoint (no point sharing) quadrilaterals, with possibly
    superimposed faces when cut plane contained inter-cell boundaries.
    
    @sa
    HyperTreeGrid HyperTreeGridAlgorithm
    
    @par Thanks: This class was written by Guenole Harel and
    Jacques-Bernard Lekien 2014 This class was modified by Philippe
    Pebay, 2016 This work was supported by Commissariat a l'Energie
    Atomique (CEA/DIF)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeGridAxisCut, obj, update, **traits)
    
    plane_normal_axis = traits.Trait(0, traits.Range(0, 2, enter_set=True, auto_set=False), help=\
        """
        Normal axis: 0=X, 1=Y, 2=Z. Default is 0
        """
    )

    def _plane_normal_axis_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPlaneNormalAxis,
                        self.plane_normal_axis)

    plane_position = traits.Float(0.0, enter_set=True, auto_set=False, help=\
        """
        Position of plane: Axis constant. Default is 0.0
        """
    )

    def _plane_position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPlanePosition,
                        self.plane_position)

    _updateable_traits_ = \
    (('progress', 'GetProgress'), ('plane_position', 'GetPlanePosition'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('progress_text',
    'GetProgressText'), ('debug', 'GetDebug'), ('abort_execute',
    'GetAbortExecute'), ('reference_count', 'GetReferenceCount'),
    ('plane_normal_axis', 'GetPlaneNormalAxis'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'plane_normal_axis', 'plane_position',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeGridAxisCut, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeGridAxisCut properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['plane_normal_axis', 'plane_position']),
            title='Edit HyperTreeGridAxisCut properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeGridAxisCut properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

