# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.hyper_tree_grid_algorithm import HyperTreeGridAlgorithm


class HyperTreeGridAxisClip(HyperTreeGridAlgorithm):
    """
    HyperTreeGridAxisClip - Axis aligned hyper tree grid clip
    
    Superclass: HyperTreeGridAlgorithm
    
    Clip an hyper tree grid along an axis aligned plane or box and output
    a hyper tree grid with same dimensionality. This filter also allows
    for reversal of the direction of what is inside versus what is
    outside by setting the inside_out instance variable.
    
    @sa
    HyperTreeGrid HyperTreeGridAlgorithm
    
    @par Thanks: This class was written by Philippe Pebay on a idea of
    Guénolé Harel and Jacques-Bernard Lekien, 2016 This work was
    supported by Commissariat a l'Energie Atomique (CEA/DIF)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeGridAxisClip, obj, update, **traits)
    
    inside_out = tvtk_base.false_bool_trait(help=\
        """
        Set/Get the inside_out flag, in the case of clip by hyperplane.
        When off, a cell is clipped out when its origin is above said
        plane intercept along the considered direction, inside otherwise.
        When on, a cell is clipped out when its origin + size is below
        said said plane intercept along the considered direction.
        """
    )

    def _inside_out_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInsideOut,
                        self.inside_out_)

    clip_type = traits.Trait('plane',
    tvtk_base.TraitRevPrefixMap({'plane': 0, 'quadric': 2, 'box': 1}), help=\
        """
        Set/get type of clip. Default value is 0 (plane clip).
        """
    )

    def _clip_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetClipType,
                        self.clip_type_)

    quadric_coefficients = traits.Trait((traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined), traits.Array(shape=(10,), dtype="float", value=(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), cols=3), enter_set=True, auto_set=False, help=\
        """
        Helpers to set/get the 10 coefficients of the quadric function
        """
    )

    def _quadric_coefficients_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetQuadricCoefficients,
                        self.quadric_coefficients)

    plane_normal_axis = traits.Trait(0, traits.Range(0, 2, enter_set=True, auto_set=False), help=\
        """
        Set/get normal axis of clipping plane: 0=X, 1=Y, 2=Z. Default
        value is 0 (X-axis normal).
        """
    )

    def _plane_normal_axis_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPlaneNormalAxis,
                        self.plane_normal_axis)

    plane_position = traits.Float(0.0, enter_set=True, auto_set=False, help=\
        """
        Set/get position of clipping plane: intercept along normal axis.
        Default value is 0.0.
        """
    )

    def _plane_position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPlanePosition,
                        self.plane_position)

    bounds = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="float", value=(-0.5, 0.5, -0.5, 0.5, -0.5, 0.5), cols=3, help=\
        """
        
        """
    )

    def _bounds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBounds,
                        self.bounds)

    def _get_quadric(self):
        return wrap_vtk(self._vtk_obj.GetQuadric())
    def _set_quadric(self, arg):
        old_val = self._get_quadric()
        self._wrap_call(self._vtk_obj.SetQuadric,
                        deref_vtk(arg))
        self.trait_property_changed('quadric', old_val, arg)
    quadric = traits.Property(_get_quadric, _set_quadric, help=\
        """
        Set/Get the clipping quadric function.
        """
    )

    def get_maximum_bounds(self, *args):
        """
        V.get_maximum_bounds([float, float, float])
        C++: void GetMaximumBounds(double[3])
        Set/get bounds of clipping box.
        """
        ret = self._wrap_call(self._vtk_obj.GetMaximumBounds, *args)
        return ret

    def get_minimum_bounds(self, *args):
        """
        V.get_minimum_bounds([float, float, float])
        C++: void GetMinimumBounds(double[3])
        Set/get bounds of clipping box.
        """
        ret = self._wrap_call(self._vtk_obj.GetMinimumBounds, *args)
        return ret

    _updateable_traits_ = \
    (('progress', 'GetProgress'), ('clip_type', 'GetClipType'),
    ('plane_position', 'GetPlanePosition'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('release_data_flag',
    'GetReleaseDataFlag'), ('progress_text', 'GetProgressText'), ('debug',
    'GetDebug'), ('abort_execute', 'GetAbortExecute'), ('reference_count',
    'GetReferenceCount'), ('bounds', 'GetBounds'), ('inside_out',
    'GetInsideOut'), ('plane_normal_axis', 'GetPlaneNormalAxis'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display', 'inside_out',
    'release_data_flag', 'clip_type', 'bounds', 'plane_normal_axis',
    'plane_position', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeGridAxisClip, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeGridAxisClip properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['inside_out'], ['clip_type'], ['bounds', 'plane_normal_axis',
            'plane_position']),
            title='Edit HyperTreeGridAxisClip properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeGridAxisClip properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

