# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.implicit_function import ImplicitFunction


class PolyPlane(ImplicitFunction):
    """
    PolyPlane - Implicit function that is generated by extrusion of a
    polyline along the Z axis
    
    Superclass: ImplicitFunction
    
    PolyPlane is, as the name suggests, an extrusion of a PolyLine.
    The extrusion direction is assumed to be the Z vector. It can be used
    in combination with a Cutter to cut a dataset with a polyplane.
    PolyPlane is a concrete implementation of the abstract class
    ImplicitFunction.
    
    @todo Generalize to extrusions along arbitrary directions.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPolyPlane, obj, update, **traits)
    
    def _get_poly_line(self):
        return wrap_vtk(self._vtk_obj.GetPolyLine())
    def _set_poly_line(self, arg):
        old_val = self._get_poly_line()
        self._wrap_call(self._vtk_obj.SetPolyLine,
                        deref_vtk(arg))
        self.trait_property_changed('poly_line', old_val, arg)
    poly_line = traits.Property(_get_poly_line, _set_poly_line, help=\
        """
        Set/get point through which plane passes. Plane is defined by
        point and normal.
        """
    )

    _updateable_traits_ = \
    (('reference_count', 'GetReferenceCount'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('debug', 'GetDebug'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PolyPlane, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PolyPlane properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit PolyPlane properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PolyPlane properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

