# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.interactor_observer import InteractorObserver


class OrientationMarkerWidget(InteractorObserver):
    """
    OrientationMarkerWidget - 2d widget for manipulating a marker prop
    
    Superclass: InteractorObserver
    
    This class provides support for interactively manipulating the
    position, size, and apparent orientation of a prop that represents an
    orientation marker.  This class works by adding its internal renderer
    to an external "parent" renderer on a different layer.  The input
    orientation marker is rendered as an overlay on the parent renderer
    and, thus, appears superposed over all props in the parent's scene. 
    The camera view of the orientation the marker is made to match that
    of the parent's by means of an observer mechanism, giving the
    illusion that the orientation of the marker reflects that of the
    prop(s) in the parent's scene.
    
    The widget listens to left mouse button and mouse movement events. It
    will change the cursor shape based on its location. If the cursor is
    over the overlay renderer, it will change the cursor shape to a
    SIZEALL shape or to a resize corner shape (e.g., SIZENW) if the
    cursor is near a corner. If the left mouse button is pressed and held
    down while moving, the overlay renderer, and hence, the orientation
    marker, is resized or moved.  I the case of a resize operation,
    releasing the left mouse button causes the widget to enforce its
    renderer to be square.  The diagonally opposite corner to the one
    moved is repositioned such that all edges of the renderer have the
    same length: the minimum.
    
    To use this object, there are two key steps: 1) invoke
    set_interactor() with the argument of the method a
    RenderWindowInteractor, and 2) invoke set_orientation_marker with an
    instance of Prop (see caveats below). Specifically, AxesActor
    and AnnotatedCubeActor are two classes designed to work with this
    class.  A composite orientation marker can be generated by adding
    instances of AxesActor and AnnotatedCubeActor to a
    PropAssembly, which can then be set as the input orientation
    marker. The widget can be also be set up in a non-interactive fashion
    by setting Ineractive to Off and sizing/placing the overlay renderer
    in its parent renderer by calling the widget's set_viewport method.
    
    @par Thanks: This class was based originally on Paraview's
    PVAxesWidget.
    
    @warning
    The input orientation marker prop should calculate its bounds as
    though they are symmetric about it's origin.  This must currently be
    done to correctly implement the camera synchronization between the
    ivar renderer and the renderer associated with the set interactor. 
    Importantly, the interactor_style associated with the interactor must
    be of the type InteractorStyle*Camera. Where desirable, the parent
    renderer should be set by the set_default_renderer method.  The parent
    renderer's number of layers is modified to 2 where required.
    
    @sa
    InteractorObserver XYPlotWidget ScalarBarWidget AxesActor
    AnnotatedCubeActor
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOrientationMarkerWidget, obj, update, **traits)
    
    interactive = tvtk_base.true_bool_trait(help=\
        """
        Set/get whether to allow this widget to be interactively
        moved/scaled. Default is On.
        """
    )

    def _interactive_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInteractive,
                        self.interactive_)

    tolerance = traits.Trait(7, traits.Range(1, 10, enter_set=True, auto_set=False), help=\
        """
        The tolerance representing the distance to the widget (in pixels)
        in which the cursor is considered to be on the widget, or on a
        widget feature (e.g., a corner point or edge).
        """
    )

    def _tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTolerance,
                        self.tolerance)

    def _get_orientation_marker(self):
        return wrap_vtk(self._vtk_obj.GetOrientationMarker())
    def _set_orientation_marker(self, arg):
        old_val = self._get_orientation_marker()
        self._wrap_call(self._vtk_obj.SetOrientationMarker,
                        deref_vtk(arg))
        self.trait_property_changed('orientation_marker', old_val, arg)
    orientation_marker = traits.Property(_get_orientation_marker, _set_orientation_marker, help=\
        """
        Set/get the orientation marker to be displayed in this widget.
        """
    )

    def _get_outline_color(self):
        return self._vtk_obj.GetOutlineColor()
    outline_color = traits.Property(_get_outline_color, help=\
        """
        Set/get the color of the outline of this widget.  The outline is
        visible when (in interactive mode) the cursor is over this
        widget. Default is white (1,1,1).
        """
    )

    def _get_viewport(self):
        return self._vtk_obj.GetViewport()
    viewport = traits.Property(_get_viewport, help=\
        """
        
        """
    )

    def execute_camera_update_event(self, *args):
        """
        V.execute_camera_update_event(Object, int, void)
        C++: void ExecuteCameraUpdateEvent(Object *o,
            unsigned long event, void *calldata)
        Callback to keep the camera for the orientation marker up to date
        with the camera in the parent renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ExecuteCameraUpdateEvent, *my_args)
        return ret

    def set_outline_color(self, *args):
        """
        V.set_outline_color(float, float, float)
        C++: void SetOutlineColor(double r, double g, double b)
        Set/get the color of the outline of this widget.  The outline is
        visible when (in interactive mode) the cursor is over this
        widget. Default is white (1,1,1).
        """
        ret = self._wrap_call(self._vtk_obj.SetOutlineColor, *args)
        return ret

    def set_viewport(self, *args):
        """
        V.set_viewport(float, float, float, float)
        C++: void SetViewport(double, double, double, double)
        V.set_viewport((float, float, float, float))
        C++: void SetViewport(double a[4])"""
        ret = self._wrap_call(self._vtk_obj.SetViewport, *args)
        return ret

    _updateable_traits_ = \
    (('picking_managed', 'GetPickingManaged'), ('enabled', 'GetEnabled'),
    ('key_press_activation', 'GetKeyPressActivation'), ('priority',
    'GetPriority'), ('reference_count', 'GetReferenceCount'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('key_press_activation_value', 'GetKeyPressActivationValue'),
    ('interactive', 'GetInteractive'), ('debug', 'GetDebug'),
    ('tolerance', 'GetTolerance'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'enabled', 'global_warning_display', 'interactive',
    'key_press_activation', 'picking_managed',
    'key_press_activation_value', 'priority', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OrientationMarkerWidget, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OrientationMarkerWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['enabled', 'interactive', 'key_press_activation',
            'picking_managed'], [], ['key_press_activation_value', 'priority',
            'tolerance']),
            title='Edit OrientationMarkerWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OrientationMarkerWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

