# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.open_gl_poly_data_mapper import OpenGLPolyDataMapper


class OpenGLSphereMapper(OpenGLPolyDataMapper):
    """
    OpenGLSphereMapper - draw spheres using imposters
    
    Superclass: OpenGLPolyDataMapper
    
    An open_gl mapper that uses imposters to draw spheres. Supports
    transparency and picking as well.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLSphereMapper, obj, update, **traits)
    
    radius = traits.Float(0.30000001192092896, enter_set=True, auto_set=False, help=\
        """
        This value will be used for the radius is the scale array is not
        provided.
        """
    )

    def _radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRadius,
                        self.radius)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, help=\
        """
        Specify the input data to map.
        """
    )

    def set_scale_array(self, *args):
        """
        V.set_scale_array(string)
        C++: void SetScaleArray(char *)
        Convenience method to set the array to scale with.
        """
        ret = self._wrap_call(self._vtk_obj.SetScaleArray, *args)
        return ret

    _updateable_traits_ = \
    (('progress', 'GetProgress'), ('resolve_coincident_topology_z_shift',
    'GetResolveCoincidentTopologyZShift'), ('cell_id_array_name',
    'GetCellIdArrayName'),
    ('resolve_coincident_topology_polygon_offset_faces',
    'GetResolveCoincidentTopologyPolygonOffsetFaces'),
    ('vertex_shader_code', 'GetVertexShaderCode'), ('piece', 'GetPiece'),
    ('ghost_level', 'GetGhostLevel'), ('scalar_mode', 'GetScalarMode'),
    ('abort_execute', 'GetAbortExecute'), ('populate_selection_settings',
    'GetPopulateSelectionSettings'), ('radius', 'GetRadius'),
    ('number_of_pieces', 'GetNumberOfPieces'), ('release_data_flag',
    'GetReleaseDataFlag'), ('interpolate_scalars_before_mapping',
    'GetInterpolateScalarsBeforeMapping'), ('debug', 'GetDebug'),
    ('force_compile_only', 'GetForceCompileOnly'),
    ('resolve_coincident_topology', 'GetResolveCoincidentTopology'),
    ('progress_text', 'GetProgressText'), ('point_id_array_name',
    'GetPointIdArrayName'), ('composite_id_array_name',
    'GetCompositeIdArrayName'), ('number_of_sub_pieces',
    'GetNumberOfSubPieces'), ('render_time', 'GetRenderTime'),
    ('reference_count', 'GetReferenceCount'), ('scalar_range',
    'GetScalarRange'), ('use_lookup_table_scalar_range',
    'GetUseLookupTableScalarRange'), ('geometry_shader_code',
    'GetGeometryShaderCode'), ('fragment_shader_code',
    'GetFragmentShaderCode'), ('process_id_array_name',
    'GetProcessIdArrayName'), ('color_mode', 'GetColorMode'),
    ('field_data_tuple_id', 'GetFieldDataTupleId'), ('scalar_visibility',
    'GetScalarVisibility'), ('scalar_material_mode',
    'GetScalarMaterialMode'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('global_immediate_mode_rendering',
    'GetGlobalImmediateModeRendering'), ('immediate_mode_rendering',
    'GetImmediateModeRendering'), ('static', 'GetStatic'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_immediate_mode_rendering',
    'global_warning_display', 'immediate_mode_rendering',
    'interpolate_scalars_before_mapping', 'release_data_flag',
    'scalar_visibility', 'static', 'use_lookup_table_scalar_range',
    'color_mode', 'resolve_coincident_topology', 'scalar_material_mode',
    'scalar_mode', 'cell_id_array_name', 'composite_id_array_name',
    'field_data_tuple_id', 'force_compile_only', 'fragment_shader_code',
    'geometry_shader_code', 'ghost_level', 'number_of_pieces',
    'number_of_sub_pieces', 'piece', 'point_id_array_name',
    'populate_selection_settings', 'process_id_array_name',
    'progress_text', 'radius', 'render_time',
    'resolve_coincident_topology_polygon_offset_faces',
    'resolve_coincident_topology_z_shift', 'scalar_range',
    'vertex_shader_code'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLSphereMapper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLSphereMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['global_immediate_mode_rendering', 'immediate_mode_rendering',
            'interpolate_scalars_before_mapping', 'scalar_visibility', 'static',
            'use_lookup_table_scalar_range'], ['color_mode',
            'resolve_coincident_topology', 'scalar_material_mode', 'scalar_mode'],
            ['cell_id_array_name', 'composite_id_array_name',
            'field_data_tuple_id', 'force_compile_only', 'fragment_shader_code',
            'geometry_shader_code', 'ghost_level', 'number_of_pieces',
            'number_of_sub_pieces', 'piece', 'point_id_array_name',
            'populate_selection_settings', 'process_id_array_name', 'radius',
            'render_time', 'resolve_coincident_topology_polygon_offset_faces',
            'resolve_coincident_topology_z_shift', 'scalar_range',
            'vertex_shader_code']),
            title='Edit OpenGLSphereMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLSphereMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

