# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.unstructured_grid_algorithm import UnstructuredGridAlgorithm


class ChacoReader(UnstructuredGridAlgorithm):
    """
    ChacoReader - Read a Chaco file and create a UnstructuredGrid.
    
    Superclass: UnstructuredGridAlgorithm
    
    ChacoReader is an unstructured grid source object that reads Chaco
    files.  The reader DOES NOT respond to piece requests. Chaco is a
    graph partitioning package developed at Sandia National Laboratories
    in the early 1990s.  (http://www.cs.sandia.gov/~bahendr/chaco.html)
    
    Note that the Chaco "edges" become VTK "cells", and the Chaco
    "vertices" become VTK "points".
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkChacoReader, obj, update, **traits)
    
    generate_edge_weight_arrays = tvtk_base.false_bool_trait(help=\
        """
        Each edge in the Chaco file connects two vertices.  The file may
        specify one or more weights for each edge.  (The weight for an
        edge from vertex A to vertex B equals the weight from B to A.)
        Indicate with the following parameter whether this reader should
        create a cell array for each weight for every edge. Default is
        OFF.
        """
    )

    def _generate_edge_weight_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateEdgeWeightArrays,
                        self.generate_edge_weight_arrays_)

    generate_global_element_id_array = tvtk_base.true_bool_trait(help=\
        """
        Indicate whether this reader should create a cell array
        containing global IDs for the cells in the output
        UnstructuredGrid.  These cells represent the edges that were
        in the Chaco file.  Each edge is a Line. Default is ON.
        """
    )

    def _generate_global_element_id_array_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateGlobalElementIdArray,
                        self.generate_global_element_id_array_)

    generate_global_node_id_array = tvtk_base.true_bool_trait(help=\
        """
        Indicate whether this reader should create a point array of
        global IDs for the points in the output UnstructuredGrid. 
        These points are the vertices that were in the Chaco file. 
        Global point IDs start at "1" for the first vertex in
        base_name.coords and go up from there. Default is ON.
        """
    )

    def _generate_global_node_id_array_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateGlobalNodeIdArray,
                        self.generate_global_node_id_array_)

    generate_vertex_weight_arrays = tvtk_base.false_bool_trait(help=\
        """
        Indicate whether this reader should create a point array for each
        vertex weight in the Chaco file. Default is OFF.
        """
    )

    def _generate_vertex_weight_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateVertexWeightArrays,
                        self.generate_vertex_weight_arrays_)

    base_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), help=\
        """
        Specify the base name of the Chaco files.  The reader will try to
        open base_name.coords and base_name.graph.
        """
    )

    def _base_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBaseName,
                        self.base_name)

    def _get_dimensionality(self):
        return self._vtk_obj.GetDimensionality()
    dimensionality = traits.Property(_get_dimensionality, help=\
        """
        Access to meta data generated by request_information.
        """
    )

    def get_edge_weight_array_name(self, *args):
        """
        V.get_edge_weight_array_name(int) -> string
        C++: const char *GetEdgeWeightArrayName(int weight)
        This method returns the name of the selected Edge weight cell
        array.  If you did not turn on generate_edge_weight_arrays, or if
        the weight you requested is invalid, it returns NULL. Weights
        begin at one and go up to number_of_edge_weights. This is a pointer
        to our copy of the name, so don't "delete" it.
        """
        ret = self._wrap_call(self._vtk_obj.GetEdgeWeightArrayName, *args)
        return ret

    def _get_global_element_id_array_name(self):
        return self._vtk_obj.GetGlobalElementIdArrayName()
    global_element_id_array_name = traits.Property(_get_global_element_id_array_name, help=\
        """
        
        """
    )

    def _get_global_node_id_array_name(self):
        return self._vtk_obj.GetGlobalNodeIdArrayName()
    global_node_id_array_name = traits.Property(_get_global_node_id_array_name, help=\
        """
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            help="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_number_of_cell_weight_arrays(self):
        return self._vtk_obj.GetNumberOfCellWeightArrays()
    number_of_cell_weight_arrays = traits.Property(_get_number_of_cell_weight_arrays, help=\
        """
        After this filter executes, this method returns the number of
        cell arrays that were created to hold the edge weights.  It is
        equal to number_of_edge_weights if generate_edge_weight_arrays was ON.
        """
    )

    def _get_number_of_edge_weights(self):
        return self._vtk_obj.GetNumberOfEdgeWeights()
    number_of_edge_weights = traits.Property(_get_number_of_edge_weights, help=\
        """
        Returns the number of weights per edge in the Chaco file, whether
        or not generate_edge_weight_arrays is ON.
        """
    )

    def _get_number_of_edges(self):
        return self._vtk_obj.GetNumberOfEdges()
    number_of_edges = traits.Property(_get_number_of_edges, help=\
        """
        Access to meta data generated by request_information.
        """
    )

    def _get_number_of_point_weight_arrays(self):
        return self._vtk_obj.GetNumberOfPointWeightArrays()
    number_of_point_weight_arrays = traits.Property(_get_number_of_point_weight_arrays, help=\
        """
        After this filter executes, this method returns the number of
        point arrays that were created to hold the vertex weights.  It is
        equal to number_of_vertex_weights if generate_vertex_weight_arrays was
        ON.
        """
    )

    def _get_number_of_vertex_weights(self):
        return self._vtk_obj.GetNumberOfVertexWeights()
    number_of_vertex_weights = traits.Property(_get_number_of_vertex_weights, help=\
        """
        Returns the number of weights per vertex in the Chaco file,
        whether or not generate_vertex_weight_arrays is ON.
        """
    )

    def _get_number_of_vertices(self):
        return self._vtk_obj.GetNumberOfVertices()
    number_of_vertices = traits.Property(_get_number_of_vertices, help=\
        """
        Access to meta data generated by request_information.
        """
    )

    def get_vertex_weight_array_name(self, *args):
        """
        V.get_vertex_weight_array_name(int) -> string
        C++: const char *GetVertexWeightArrayName(int weight)
        This method returns the name of the selected Vertex weight point
        array.  If you did not turn on generate_vertex_weight_arrays, or if
        the weight you requested is invalid, it returns NULL. Weights
        begin at one and go up to number_of_vertex_weights. This is a
        pointer to our copy of the name, so don't "delete" it.
        """
        ret = self._wrap_call(self._vtk_obj.GetVertexWeightArrayName, *args)
        return ret

    _updateable_traits_ = \
    (('generate_global_node_id_array', 'GetGenerateGlobalNodeIdArray'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('base_name',
    'GetBaseName'), ('generate_edge_weight_arrays',
    'GetGenerateEdgeWeightArrays'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'),
    ('generate_global_element_id_array',
    'GetGenerateGlobalElementIdArray'), ('generate_vertex_weight_arrays',
    'GetGenerateVertexWeightArrays'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'), ('progress',
    'GetProgress'), ('abort_execute', 'GetAbortExecute'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'generate_edge_weight_arrays',
    'generate_global_element_id_array', 'generate_global_node_id_array',
    'generate_vertex_weight_arrays', 'global_warning_display',
    'release_data_flag', 'base_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ChacoReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ChacoReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['generate_edge_weight_arrays',
            'generate_global_element_id_array', 'generate_global_node_id_array',
            'generate_vertex_weight_arrays'], [], ['base_name']),
            title='Edit ChacoReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ChacoReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

