# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.contour_grid import ContourGrid


class SMPContourGrid(ContourGrid):
    """
    SMPContourGrid - a subclass of ContourGrid that works in
    parallel SMPContourGrid performs the same functionaliy as
    ContourGrid but does it using multiple threads.
    
    Superclass: ContourGrid
    
    This will probably be merged with ContourGrid in the future.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSMPContourGrid, obj, update, **traits)
    
    merge_pieces = tvtk_base.true_bool_trait(help=\
        """
        If merge_pieces is true (default), this filter will merge all
        pieces generated by processing the input with multiple threads.
        The output will be a PolyData. Note that this has a slight
        overhead which becomes more significant as the number of threads
        used grows. If merge_pieces is false, this filter will generate a
        MultiBlock of PolyData where the number of pieces will be
        equal to the number of threads used.
        """
    )

    def _merge_pieces_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMergePieces,
                        self.merge_pieces_)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            help="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('release_data_flag', 'GetReleaseDataFlag'), ('number_of_contours',
    'GetNumberOfContours'), ('merge_pieces', 'GetMergePieces'),
    ('output_points_precision', 'GetOutputPointsPrecision'),
    ('reference_count', 'GetReferenceCount'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress_text', 'GetProgressText'),
    ('debug', 'GetDebug'), ('compute_scalars', 'GetComputeScalars'),
    ('abort_execute', 'GetAbortExecute'), ('compute_gradients',
    'GetComputeGradients'), ('generate_triangles',
    'GetGenerateTriangles'), ('progress', 'GetProgress'),
    ('compute_normals', 'GetComputeNormals'), ('use_scalar_tree',
    'GetUseScalarTree'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compute_gradients', 'compute_normals',
    'compute_scalars', 'debug', 'generate_triangles',
    'global_warning_display', 'merge_pieces', 'release_data_flag',
    'use_scalar_tree', 'number_of_contours', 'output_points_precision',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SMPContourGrid, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SMPContourGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_gradients', 'compute_normals', 'compute_scalars',
            'generate_triangles', 'merge_pieces', 'use_scalar_tree'], [],
            ['number_of_contours', 'output_points_precision']),
            title='Edit SMPContourGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SMPContourGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

