# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.mask_points import MaskPoints


class PMaskPoints(MaskPoints):
    """
    PMaskPoints - parallel Mask Points
    
    Superclass: MaskPoints
    
    The difference between this implementation and MaskPoints is the
    use of the MultiProcessController and that
    proportional_maximum_number_of_points is obeyed.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPMaskPoints, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, help=\
        """
        Set the communicator object for interprocess communication
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            help="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('release_data_flag', 'GetReleaseDataFlag'),
    ('single_vertex_per_cell', 'GetSingleVertexPerCell'), ('on_ratio',
    'GetOnRatio'), ('output_points_precision',
    'GetOutputPointsPrecision'), ('random_mode', 'GetRandomMode'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('debug',
    'GetDebug'), ('offset', 'GetOffset'), ('abort_execute',
    'GetAbortExecute'), ('reference_count', 'GetReferenceCount'),
    ('random_mode_type', 'GetRandomModeType'), ('progress',
    'GetProgress'), ('proportional_maximum_number_of_points',
    'GetProportionalMaximumNumberOfPoints'), ('generate_vertices',
    'GetGenerateVertices'), ('maximum_number_of_points',
    'GetMaximumNumberOfPoints'), ('progress_text', 'GetProgressText'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'generate_vertices',
    'global_warning_display', 'proportional_maximum_number_of_points',
    'random_mode', 'release_data_flag', 'single_vertex_per_cell',
    'maximum_number_of_points', 'offset', 'on_ratio',
    'output_points_precision', 'progress_text', 'random_mode_type'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PMaskPoints, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PMaskPoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['generate_vertices', 'proportional_maximum_number_of_points',
            'random_mode', 'single_vertex_per_cell'], [],
            ['maximum_number_of_points', 'offset', 'on_ratio',
            'output_points_precision', 'random_mode_type']),
            title='Edit PMaskPoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PMaskPoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

