# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.mapper import Mapper


class DataSetMapper(Mapper):
    """
    DataSetMapper - map DataSet and derived classes to graphics
    primitives
    
    Superclass: Mapper
    
    DataSetMapper is a mapper to map data sets (i.e., DataSet and
    all derived classes) to graphics primitives. The mapping procedure is
    as follows: all 0d, 1d, and 2d cells are converted into points,
    lines, and polygons/triangle strips and then mapped to the graphics
    system. The 2d faces of 3d cells are mapped only if they are used by
    only one cell, i.e., on the boundary of the data set.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDataSetMapper, obj, update, **traits)
    
    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, help=\
        """
        Set the Input of this mapper.
        """
    )

    def _get_poly_data_mapper(self):
        return wrap_vtk(self._vtk_obj.GetPolyDataMapper())
    poly_data_mapper = traits.Property(_get_poly_data_mapper, help=\
        """
        Get the internal poly data mapper used to map data set to
        graphics system.
        """
    )

    def set_input_data(self, *args):
        """
        V.set_input_data(DataSet)
        C++: void SetInputData(DataSet *input)
        Set the Input of this mapper.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputData, *my_args)
        return ret

    _updateable_traits_ = \
    (('scalar_range', 'GetScalarRange'), ('immediate_mode_rendering',
    'GetImmediateModeRendering'), ('global_immediate_mode_rendering',
    'GetGlobalImmediateModeRendering'), ('debug', 'GetDebug'),
    ('render_time', 'GetRenderTime'), ('abort_execute',
    'GetAbortExecute'), ('field_data_tuple_id', 'GetFieldDataTupleId'),
    ('resolve_coincident_topology_polygon_offset_faces',
    'GetResolveCoincidentTopologyPolygonOffsetFaces'),
    ('scalar_material_mode', 'GetScalarMaterialMode'),
    ('resolve_coincident_topology_z_shift',
    'GetResolveCoincidentTopologyZShift'), ('color_mode', 'GetColorMode'),
    ('static', 'GetStatic'), ('progress_text', 'GetProgressText'),
    ('scalar_visibility', 'GetScalarVisibility'), ('release_data_flag',
    'GetReleaseDataFlag'), ('interpolate_scalars_before_mapping',
    'GetInterpolateScalarsBeforeMapping'), ('force_compile_only',
    'GetForceCompileOnly'), ('resolve_coincident_topology',
    'GetResolveCoincidentTopology'), ('reference_count',
    'GetReferenceCount'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress', 'GetProgress'),
    ('use_lookup_table_scalar_range', 'GetUseLookupTableScalarRange'),
    ('scalar_mode', 'GetScalarMode'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_immediate_mode_rendering',
    'global_warning_display', 'immediate_mode_rendering',
    'interpolate_scalars_before_mapping', 'release_data_flag',
    'scalar_visibility', 'static', 'use_lookup_table_scalar_range',
    'color_mode', 'resolve_coincident_topology', 'scalar_material_mode',
    'scalar_mode', 'field_data_tuple_id', 'force_compile_only',
    'progress_text', 'render_time',
    'resolve_coincident_topology_polygon_offset_faces',
    'resolve_coincident_topology_z_shift', 'scalar_range'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DataSetMapper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DataSetMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['global_immediate_mode_rendering', 'immediate_mode_rendering',
            'interpolate_scalars_before_mapping', 'scalar_visibility', 'static',
            'use_lookup_table_scalar_range'], ['color_mode',
            'resolve_coincident_topology', 'scalar_material_mode', 'scalar_mode'],
            ['field_data_tuple_id', 'force_compile_only', 'render_time',
            'resolve_coincident_topology_polygon_offset_faces',
            'resolve_coincident_topology_z_shift', 'scalar_range']),
            title='Edit DataSetMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DataSetMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

