# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.merge_points import MergePoints


class SMPMergePoints(MergePoints):
    """
    SMPMergePoints - Class designed to help with merging of points in
    parallel
    
    Superclass: MergePoints
    
    SMPMergePoints is a subclass of MergePoints designed to help
    with merging of points generated by using multiple locators in
    parallel. Its main functionality is provided by the Merge function.
    It also has a few additional convenience functions. Merge is thread
    safe as long as no two threads are merging the same bin. The common
    way of using SMPMergePoints is:
    - Initialize with out_locator->_initialize_merge()
    - Allocate points with out_locator->_get_points()->_resize(num_pts)
      (num_pts should be >= total number of points)
    - Do bunch of merging with out_locator->_merge(in_locator[i], ...) (this
    can be done in parallel as long as no two bins are done at the same
      time)
    - Fix the size of points with out_locator->_fix_size_of_point_array()
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSMPMergePoints, obj, update, **traits)
    
    def _get_max_id(self):
        return self._vtk_obj.GetMaxId()
    max_id = traits.Property(_get_max_id, help=\
        """
        Returns the biggest id in the locator.
        """
    )

    def get_number_of_ids_in_bucket(self, *args):
        """
        V.get_number_of_ids_in_bucket(int) -> int
        C++: IdType GetNumberOfIdsInBucket(IdType idx)
        Retuns the number of points in a bin.
        """
        ret = self._wrap_call(self._vtk_obj.GetNumberOfIdsInBucket, *args)
        return ret

    def fix_size_of_point_array(self):
        """
        V.fix_size_of_point_array()
        C++: void FixSizeOfPointArray()
        At the of the merge, this can be called to set the max_id of the
        points array to the maximum id in the locator. The current design
        usage is as follows:
        - Allocate points with points->_resize(num_pts). num_pts should be
          >= total number of points
        - Do bunch of merging with out_locator->_merge(in_locator[i], ...)
        - Fix the size of points with out_locator->_fix_size_of_point_array()
        """
        ret = self._vtk_obj.FixSizeOfPointArray()
        return ret
        

    def initialize_merge(self):
        """
        V.initialize_merge()
        C++: void InitializeMerge()
        This should be called from 1 thread before any call to Merge.
        """
        ret = self._vtk_obj.InitializeMerge()
        return ret
        

    def merge(self, *args):
        """
        V.merge(SMPMergePoints, int, PointData, PointData,
            IdList)
        C++: void Merge(SMPMergePoints *locator, IdType idx,
            PointData *outPd, PointData *inPd, IdList *idList)
        Merge the points of one of the bins from the given locator to the
        same bin of the current locator. Note that this requires that the
        two locators have identical binning structures. This also merges
        point data given in the in_pd argument to the out_pd. Furthermore,
        it generates a map of the old ids of the input locator to the new
        ids. This is stored in the id_list argument. The map is
        id_list[old_id] = new_id.
        """
        my_args = deref_array(args, [('vtkSMPMergePoints', 'int', 'vtkPointData', 'vtkPointData', 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.Merge, *my_args)
        return ret

    _updateable_traits_ = \
    (('automatic', 'GetAutomatic'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('divisions',
    'GetDivisions'), ('number_of_points_per_bucket',
    'GetNumberOfPointsPerBucket'), ('max_level', 'GetMaxLevel'),
    ('tolerance', 'GetTolerance'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['automatic', 'debug', 'global_warning_display', 'divisions',
    'max_level', 'number_of_points_per_bucket', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SMPMergePoints, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SMPMergePoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['automatic'], [], ['divisions', 'max_level',
            'number_of_points_per_bucket', 'tolerance']),
            title='Edit SMPMergePoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SMPMergePoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

