# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.open_gl_render_window import OpenGLRenderWindow


class Win32OpenGLRenderWindow(OpenGLRenderWindow):
    """
    Win32OpenGLRenderWindow - no description provided.
    
    Superclass: OpenGLRenderWindow
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkWin32OpenGLRenderWindow, obj, update, **traits)
    
    position = traits.Array(auto_set=False, enter_set=True, shape=(2,), dtype=int, value=(0, 0), cols=2, help=\
        """
        Set the position of the window.
        """
    )

    def _position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPosition,
                        self.position)

    current_cursor = traits.Int(0, auto_set=False, enter_set=True, help=\
        """
        Change the shape of the cursor
        """
    )

    def _current_cursor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCurrentCursor,
                        self.current_cursor)

    window_name = traits.String('Visualization Toolkit - OpenGL', auto_set=False, enter_set=True, help=\
        """
        Set the name of the window. This appears at the top of the window
        normally.
        """
    )

    def _window_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWindowName,
                        self.window_name)

    size = traits.Array(auto_set=False, enter_set=True, shape=(2,), dtype=int, value=(0, 0), cols=2, help=\
        """
        Set the size of the window in pixels.
        """
    )

    def _size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSize,
                        self.size)

    def clean(self):
        """
        V.clean()
        C++: void Clean()
        Clean up device contexts, rendering contexts, etc.
        """
        ret = self._vtk_obj.Clean()
        return ret
        

    def pref_full_screen(self):
        """
        V.pref_full_screen()
        C++: virtual void PrefFullScreen(void)
        Set the preferred window size to full screen.
        """
        ret = self._vtk_obj.PrefFullScreen()
        return ret
        

    def window_initialize(self):
        """
        V.window_initialize()
        C++: virtual void WindowInitialize(void)
        Create the window
        """
        ret = self._vtk_obj.WindowInitialize()
        return ret
        

    _updateable_traits_ = \
    (('position', 'GetPosition'), ('line_smoothing', 'GetLineSmoothing'),
    ('stereo_type', 'GetStereoType'), ('fd_frames', 'GetFDFrames'),
    ('tile_viewport', 'GetTileViewport'), ('window_name',
    'GetWindowName'), ('context_supports_open_gl32',
    'GetContextSupportsOpenGL32'), ('stereo_render', 'GetStereoRender'),
    ('device_index', 'GetDeviceIndex'), ('double_buffer',
    'GetDoubleBuffer'), ('dpi', 'GetDPI'), ('polygon_smoothing',
    'GetPolygonSmoothing'), ('current_cursor', 'GetCurrentCursor'),
    ('erase', 'GetErase'), ('use_constant_fd_offsets',
    'GetUseConstantFDOffsets'), ('swap_buffers', 'GetSwapBuffers'),
    ('point_smoothing', 'GetPointSmoothing'), ('stencil_capable',
    'GetStencilCapable'), ('is_picking', 'GetIsPicking'),
    ('anaglyph_color_saturation', 'GetAnaglyphColorSaturation'),
    ('anaglyph_color_mask', 'GetAnaglyphColorMask'),
    ('use_off_screen_buffers', 'GetUseOffScreenBuffers'), ('debug',
    'GetDebug'), ('tile_scale', 'GetTileScale'), ('in_abort_check',
    'GetInAbortCheck'), ('global_maximum_number_of_multi_samples',
    'GetGlobalMaximumNumberOfMultiSamples'), ('reference_count',
    'GetReferenceCount'), ('abort_render', 'GetAbortRender'),
    ('desired_update_rate', 'GetDesiredUpdateRate'), ('borders',
    'GetBorders'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('stereo_capable_window', 'GetStereoCapableWindow'), ('full_screen',
    'GetFullScreen'), ('multi_samples', 'GetMultiSamples'),
    ('number_of_layers', 'GetNumberOfLayers'), ('off_screen_rendering',
    'GetOffScreenRendering'), ('sub_frames', 'GetSubFrames'), ('mapped',
    'GetMapped'), ('alpha_bit_planes', 'GetAlphaBitPlanes'), ('size',
    'GetSize'), ('aa_frames', 'GetAAFrames'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['borders', 'debug', 'double_buffer', 'erase', 'full_screen',
    'global_warning_display', 'is_picking', 'line_smoothing', 'mapped',
    'off_screen_rendering', 'point_smoothing', 'polygon_smoothing',
    'stencil_capable', 'stereo_capable_window', 'stereo_render',
    'swap_buffers', 'stereo_type', 'aa_frames', 'abort_render',
    'alpha_bit_planes', 'anaglyph_color_mask',
    'anaglyph_color_saturation', 'context_supports_open_gl32',
    'current_cursor', 'desired_update_rate', 'device_index', 'dpi',
    'fd_frames', 'global_maximum_number_of_multi_samples',
    'in_abort_check', 'multi_samples', 'number_of_layers', 'position',
    'size', 'sub_frames', 'tile_scale', 'tile_viewport',
    'use_constant_fd_offsets', 'use_off_screen_buffers', 'window_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Win32OpenGLRenderWindow, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Win32OpenGLRenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['borders', 'double_buffer', 'erase', 'full_screen',
            'is_picking', 'line_smoothing', 'mapped', 'off_screen_rendering',
            'point_smoothing', 'polygon_smoothing', 'stencil_capable',
            'stereo_capable_window', 'stereo_render', 'swap_buffers'],
            ['stereo_type'], ['aa_frames', 'abort_render', 'alpha_bit_planes',
            'anaglyph_color_mask', 'anaglyph_color_saturation',
            'context_supports_open_gl32', 'current_cursor', 'desired_update_rate',
            'device_index', 'dpi', 'fd_frames',
            'global_maximum_number_of_multi_samples', 'in_abort_check',
            'multi_samples', 'number_of_layers', 'position', 'size', 'sub_frames',
            'tile_scale', 'tile_viewport', 'use_constant_fd_offsets',
            'use_off_screen_buffers', 'window_name']),
            title='Edit Win32OpenGLRenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Win32OpenGLRenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

