# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.multi_block_data_set_algorithm import MultiBlockDataSetAlgorithm


class QuadRotationalExtrusionFilter(MultiBlockDataSetAlgorithm):
    """
    QuadRotationalExtrusionFilter - sweep polygonal data creating
    "skirt" from free edges and lines, and lines from vertices
    
    Superclass: MultiBlockDataSetAlgorithm
    
    QuadRotationalExtrusionFilter is a modeling filter. It takes
    polygonal data as input and generates polygonal data on output. The
    input dataset is swept around the z-axis to create new polygonal
    primitives. These primitives form a "skirt" or swept surface. For
    example, sweeping a line results in a cylindrical shell, and sweeping
    a circle creates a torus.
    
    There are a number of control parameters for this filter. You can
    control whether the sweep of a 2d object (i.e., polygon or triangle
    strip) is capped with the generating geometry via the "Capping"
    instance variable. Also, you can control the angle of rotation, and
    whether translation along the z-axis is performed along with the
    rotation. (Translation is useful for creating "springs".) You also
    can adjust the radius of the generating geometry using the
    "_delta_rotation" instance variable.
    
    The skirt is generated by locating certain topological features. Free
    edges (edges of polygons or triangle strips only used by one polygon
    or triangle strips) generate surfaces. This is true also of lines or
    polylines. Vertices generate lines.
    
    This filter can be used to model axisymmetric objects like cylinders,
    bottles, and wine glasses; or translational/rotational symmetric
    objects like springs or corkscrews.
    
    @warning
    If the object sweeps 360 degrees, radius does not vary, and the
    object does not translate, capping is not performed. This is because
    the cap is unnecessary.
    
    @warning
    Some polygonal objects have no free edges (e.g., sphere). When swept,
    this will result in two separate surfaces if capping is on, or no
    surface if capping is off.
    
    @sa
    LinearExtrusionFilter RotationalExtrusionFilter
    
    @par Thanks: This class was initially developed by Daniel Aguilera,
    CEA/DIF Ported and modified by Philippe Pebay, Kitware, 2011
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkQuadRotationalExtrusionFilter, obj, update, **traits)
    
    capping = tvtk_base.true_bool_trait(help=\
        """
        Turn on/off the capping of the skirt.
        """
    )

    def _capping_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCapping,
                        self.capping_)

    axis = traits.Trait('z',
    tvtk_base.TraitRevPrefixMap({'y': 1, 'x': 0, 'z': 2}), help=\
        """
        Set the axis of rotation to use. It is set by default to Z.
        """
    )

    def _axis_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAxis,
                        self.axis_)

    resolution = traits.Trait(12, traits.Range(1, 2147483647, enter_set=True, auto_set=False), help=\
        """
        Set/Get resolution of sweep operation. Resolution controls the
        number of intermediate node points.
        """
    )

    def _resolution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResolution,
                        self.resolution)

    default_angle = traits.Float(360.0, auto_set=False, enter_set=True, help=\
        """
        Set/Get angle of rotation.
        """
    )

    def _default_angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDefaultAngle,
                        self.default_angle)

    delta_radius = traits.Float(0.0, auto_set=False, enter_set=True, help=\
        """
        Set/Get change in radius during sweep process.
        """
    )

    def _delta_radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDeltaRadius,
                        self.delta_radius)

    translation = traits.Float(0.0, auto_set=False, enter_set=True, help=\
        """
        Set/Get total amount of translation along the z-axis.
        """
    )

    def _translation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTranslation,
                        self.translation)

    def add_per_block_angle(self, *args):
        """
        V.add_per_block_angle(int, float)
        C++: void AddPerBlockAngle(IdType blockId, double angle)
        Set/Get angles of rotation for each block in a composite data
        set.
        """
        ret = self._wrap_call(self._vtk_obj.AddPerBlockAngle, *args)
        return ret

    def remove_all_per_block_angles(self):
        """
        V.remove_all_per_block_angles()
        C++: void RemoveAllPerBlockAngles()
        Set/Get angles of rotation for each block in a composite data
        set.
        """
        ret = self._vtk_obj.RemoveAllPerBlockAngles()
        return ret
        

    _updateable_traits_ = \
    (('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('reference_count', 'GetReferenceCount'), ('resolution',
    'GetResolution'), ('axis', 'GetAxis'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('capping', 'GetCapping'), ('translation',
    'GetTranslation'), ('progress', 'GetProgress'), ('default_angle',
    'GetDefaultAngle'), ('abort_execute', 'GetAbortExecute'),
    ('progress_text', 'GetProgressText'), ('delta_radius',
    'GetDeltaRadius'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'capping', 'debug', 'global_warning_display',
    'release_data_flag', 'axis', 'default_angle', 'delta_radius',
    'progress_text', 'resolution', 'translation'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(QuadRotationalExtrusionFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit QuadRotationalExtrusionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['capping'], ['axis'], ['default_angle', 'delta_radius',
            'resolution', 'translation']),
            title='Edit QuadRotationalExtrusionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit QuadRotationalExtrusionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

