# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.actor import Actor


class PolarAxesActor(Actor):
    """
    PolarAxesActor - create an actor of a polar axes -
    
    Superclass: Actor
    
    PolarAxesActor is a composite actor that draws polar axes in a
    specified plane for a give pole. Currently the plane has to be the xy
    plane.
    
    @par Thanks: This class was written by Philippe Pebay, Kitware SAS
    2011. This work was supported by CEA/DIF - Commissariat a l'Energie
    Atomique, Centre DAM Ile-De-France, BP12, F-91297 Arpajon, France.
    
    @sa
    Actor AxisActor PolarAxesActor
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPolarAxesActor, obj, update, **traits)
    
    log = tvtk_base.false_bool_trait(help=\
        """
        Enable/Disable log scale Default: true
        """
    )

    def _log_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLog,
                        self.log_)

    radial_axes_origin_to_polar_axis = tvtk_base.true_bool_trait(help=\
        """
        If On, the radial axes are drawn from the angle of the polar_axis
        (i.e. this->_minimal_radius) and continue counterclockwise with the
        step delta_angle_radial_axes. if Off, the start angle is 0.0, i.e.
        the angle on the major radius of the ellipse.
        """
    )

    def _radial_axes_origin_to_polar_axis_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRadialAxesOriginToPolarAxis,
                        self.radial_axes_origin_to_polar_axis_)

    axis_minor_tick_visibility = tvtk_base.false_bool_trait(help=\
        """
        Turn on and off the visibility of minor ticks on polar axis and
        last radial axis.
        """
    )

    def _axis_minor_tick_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAxisMinorTickVisibility,
                        self.axis_minor_tick_visibility_)

    polar_title_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of titles for polar axis.
        """
    )

    def _polar_title_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarTitleVisibility,
                        self.polar_title_visibility_)

    radial_axes_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of non-polar radial axes.
        """
    )

    def _radial_axes_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRadialAxesVisibility,
                        self.radial_axes_visibility_)

    arc_tick_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of major ticks on the last arc.
        """
    )

    def _arc_tick_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArcTickVisibility,
                        self.arc_tick_visibility_)

    polar_arcs_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of arcs for polar axis.
        """
    )

    def _polar_arcs_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarArcsVisibility,
                        self.polar_arcs_visibility_)

    polar_axis_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of the polar axis.
        """
    )

    def _polar_axis_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarAxisVisibility,
                        self.polar_axis_visibility_)

    arc_minor_tick_visibility = tvtk_base.false_bool_trait(help=\
        """
        Turn on and off the visibility of minor ticks on the last arc.
        """
    )

    def _arc_minor_tick_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArcMinorTickVisibility,
                        self.arc_minor_tick_visibility_)

    axis_tick_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of major ticks on polar axis and
        last radial axis.
        """
    )

    def _axis_tick_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAxisTickVisibility,
                        self.axis_tick_visibility_)

    auto_subdivide_polar_axis = tvtk_base.true_bool_trait(help=\
        """
        Set/Get whether the number of polar axis ticks and arcs should be
        automatically calculated Default: true
        """
    )

    def _auto_subdivide_polar_axis_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAutoSubdividePolarAxis,
                        self.auto_subdivide_polar_axis_)

    draw_polar_arcs_gridlines = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of inner polar arcs grid lines
        """
    )

    def _draw_polar_arcs_gridlines_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDrawPolarArcsGridlines,
                        self.draw_polar_arcs_gridlines_)

    polar_tick_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the overall visibility of ticks.
        """
    )

    def _polar_tick_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarTickVisibility,
                        self.polar_tick_visibility_)

    arc_ticks_origin_to_polar_axis = tvtk_base.true_bool_trait(help=\
        """
        If On, the ticks are drawn from the angle of the polar_axis (i.e.
        this->_minimal_radius) and continue counterclockwise with the step
        delta_angle Major/Minor. if Off, the start angle is 0.0, i.e. the
        angle on the major radius of the ellipse.
        """
    )

    def _arc_ticks_origin_to_polar_axis_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArcTicksOriginToPolarAxis,
                        self.arc_ticks_origin_to_polar_axis_)

    draw_radial_gridlines = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of inner radial grid lines
        """
    )

    def _draw_radial_gridlines_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDrawRadialGridlines,
                        self.draw_radial_gridlines_)

    radial_title_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of titles for non-polar radial
        axes.
        """
    )

    def _radial_title_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRadialTitleVisibility,
                        self.radial_title_visibility_)

    polar_label_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of labels for polar axis.
        """
    )

    def _polar_label_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarLabelVisibility,
                        self.polar_label_visibility_)

    arc_major_tick_size = traits.Float(0.1, auto_set=False, enter_set=True, help=\
        """
        Set/Get the size of the major ticks on the last arc.
        """
    )

    def _arc_major_tick_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArcMajorTickSize,
                        self.arc_major_tick_size)

    polar_axis_tick_ratio_thickness = traits.Float(0.5, auto_set=False, enter_set=True, help=\
        """
        Set/Get the ratio between major and minor Polar Axis ticks
        thickness
        """
    )

    def _polar_axis_tick_ratio_thickness_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarAxisTickRatioThickness,
                        self.polar_axis_tick_ratio_thickness)

    auto_scale_radius = traits.Bool(False, auto_set=False, enter_set=True, help=\
        """
        Turn on and off the auto-scaling of the maximum radius. Default:
        false
        """
    )

    def _auto_scale_radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAutoScaleRadius,
                        self.auto_scale_radius)

    arc_major_tick_thickness = traits.Float(1.0, auto_set=False, enter_set=True, help=\
        """
        Set/Get the size of the thickness of the last arc ticks
        """
    )

    def _arc_major_tick_thickness_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArcMajorTickThickness,
                        self.arc_major_tick_thickness)

    pole = traits.Array(auto_set=False, enter_set=True, shape=(3,), dtype=float, value=(0.0, 0.0, 0.0), cols=3, help=\
        """
        Explicitly specify the coordinate of the pole.
        """
    )

    def _pole_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPole,
                        self.pole)

    screen_size = traits.Float(10.0, auto_set=False, enter_set=True, help=\
        """
        Explicitly specify the screen size of title and label text.
        screen_size detemines the size of the text in terms of screen
        pixels. Default: 10.0.
        """
    )

    def _screen_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScreenSize,
                        self.screen_size)

    view_angle_lod_threshold = traits.Trait(0.3, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), help=\
        """
        Set view angle LOD threshold [0.0 - 1.0] for titles and labels.
        """
    )

    def _view_angle_lod_threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetViewAngleLODThreshold,
                        self.view_angle_lod_threshold)

    delta_angle_radial_axes = traits.Float(45.0, auto_set=False, enter_set=True, help=\
        """
        Set/Get the angle between 2 radial axes.
        """
    )

    def _delta_angle_radial_axes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDeltaAngleRadialAxes,
                        self.delta_angle_radial_axes)

    bounds = traits.Trait((traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined), traits.Array(shape=(6,), dtype=float, value=(0.0, 0.0, 0.0, 0.0, 0.0, 0.0), cols=3), enter_set=True, auto_set=False, help=\
        """
        
        """
    )

    def _bounds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBounds,
                        self.bounds)

    def _get_last_radial_axis_property(self):
        return wrap_vtk(self._vtk_obj.GetLastRadialAxisProperty())
    def _set_last_radial_axis_property(self, arg):
        old_val = self._get_last_radial_axis_property()
        self._wrap_call(self._vtk_obj.SetLastRadialAxisProperty,
                        deref_vtk(arg))
        self.trait_property_changed('last_radial_axis_property', old_val, arg)
    last_radial_axis_property = traits.Property(_get_last_radial_axis_property, _set_last_radial_axis_property, help=\
        """
        Get/Set last radial axis actor properties.
        """
    )

    delta_angle_major = traits.Float(10.0, auto_set=False, enter_set=True, help=\
        """
        Set/Get the angle between 2 major ticks on the last arc.
        """
    )

    def _delta_angle_major_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDeltaAngleMajor,
                        self.delta_angle_major)

    def _get_secondary_polar_arcs_property(self):
        return wrap_vtk(self._vtk_obj.GetSecondaryPolarArcsProperty())
    def _set_secondary_polar_arcs_property(self, arg):
        old_val = self._get_secondary_polar_arcs_property()
        self._wrap_call(self._vtk_obj.SetSecondaryPolarArcsProperty,
                        deref_vtk(arg))
        self.trait_property_changed('secondary_polar_arcs_property', old_val, arg)
    secondary_polar_arcs_property = traits.Property(_get_secondary_polar_arcs_property, _set_secondary_polar_arcs_property, help=\
        """
        Get/Set secondary polar arcs actors property.
        """
    )

    def _get_secondary_radial_axes_text_property(self):
        return wrap_vtk(self._vtk_obj.GetSecondaryRadialAxesTextProperty())
    def _set_secondary_radial_axes_text_property(self, arg):
        old_val = self._get_secondary_radial_axes_text_property()
        self._wrap_call(self._vtk_obj.SetSecondaryRadialAxesTextProperty,
                        deref_vtk(arg))
        self.trait_property_changed('secondary_radial_axes_text_property', old_val, arg)
    secondary_radial_axes_text_property = traits.Property(_get_secondary_radial_axes_text_property, _set_secondary_radial_axes_text_property, help=\
        """
        Set/Get the secondary radial axes text property.
        """
    )

    def _get_secondary_radial_axes_property(self):
        return wrap_vtk(self._vtk_obj.GetSecondaryRadialAxesProperty())
    def _set_secondary_radial_axes_property(self, arg):
        old_val = self._get_secondary_radial_axes_property()
        self._wrap_call(self._vtk_obj.SetSecondaryRadialAxesProperty,
                        deref_vtk(arg))
        self.trait_property_changed('secondary_radial_axes_property', old_val, arg)
    secondary_radial_axes_property = traits.Property(_get_secondary_radial_axes_property, _set_secondary_radial_axes_property, help=\
        """
        Get/Set secondary radial axes actors properties.
        """
    )

    arc_tick_ratio_size = traits.Float(0.3, auto_set=False, enter_set=True, help=\
        """
        Set/Get the ratio between major and minor Arc ticks size
        """
    )

    def _arc_tick_ratio_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArcTickRatioSize,
                        self.arc_tick_ratio_size)

    delta_range_major = traits.Float(1.0, auto_set=False, enter_set=True, help=\
        """
        Set/Get the step between 2 major ticks, in range value (values
        displayed on the axis).
        """
    )

    def _delta_range_major_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDeltaRangeMajor,
                        self.delta_range_major)

    number_of_radial_axes = traits.Int(0, auto_set=False, enter_set=True, help=\
        """
        Gets/Sets the number of radial axes
        """
    )

    def _number_of_radial_axes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfRadialAxes,
                        self.number_of_radial_axes)

    minimum_angle = traits.Float(0.0, auto_set=False, enter_set=True, help=\
        """
        Set/Get the minimum radius of the polar coordinates (in degrees).
        """
    )

    def _minimum_angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinimumAngle,
                        self.minimum_angle)

    polar_axis_major_tick_thickness = traits.Float(1.0, auto_set=False, enter_set=True, help=\
        """
        Set/Get the size of the thickness of polar axis ticks
        """
    )

    def _polar_axis_major_tick_thickness_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarAxisMajorTickThickness,
                        self.polar_axis_major_tick_thickness)

    polar_axis_tick_ratio_size = traits.Float(0.3, auto_set=False, enter_set=True, help=\
        """
        Set/Get the ratio between major and minor Polar Axis ticks size
        """
    )

    def _polar_axis_tick_ratio_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarAxisTickRatioSize,
                        self.polar_axis_tick_ratio_size)

    smallest_visible_polar_angle = traits.Trait(0.5, traits.Range(0.0, 5.0, enter_set=True, auto_set=False), help=\
        """
        Set/Get the minimum radial angle distinguishable from polar axis
        NB: This is used only when polar axis is visible Default: 0.5
        """
    )

    def _smallest_visible_polar_angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSmallestVisiblePolarAngle,
                        self.smallest_visible_polar_angle)

    polar_axis_title = traits.String('Radial Distance', auto_set=False, enter_set=True, help=\
        """
        Set/Get the labels for the polar axis. Default: "Radial
        Distance".
        """
    )

    def _polar_axis_title_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarAxisTitle,
                        self.polar_axis_title)

    last_axis_tick_ratio_thickness = traits.Float(0.5, auto_set=False, enter_set=True, help=\
        """
        Set/Get the ratio between major and minor Last Radial axis ticks
        thickness
        """
    )

    def _last_axis_tick_ratio_thickness_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLastAxisTickRatioThickness,
                        self.last_axis_tick_ratio_thickness)

    arc_tick_ratio_thickness = traits.Float(0.5, auto_set=False, enter_set=True, help=\
        """
        Set/Get the ratio between major and minor Arc ticks thickness
        """
    )

    def _arc_tick_ratio_thickness_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArcTickRatioThickness,
                        self.arc_tick_ratio_thickness)

    def _get_camera(self):
        return wrap_vtk(self._vtk_obj.GetCamera())
    def _set_camera(self, arg):
        old_val = self._get_camera()
        self._wrap_call(self._vtk_obj.SetCamera,
                        deref_vtk(arg))
        self.trait_property_changed('camera', old_val, arg)
    camera = traits.Property(_get_camera, _set_camera, help=\
        """
        Set/Get the camera to perform scaling and translation of the
        PolarAxesActor.
        """
    )

    minimum_radius = traits.Float(0.0, auto_set=False, enter_set=True, help=\
        """
        Set/Get the minimal radius of the polar coordinates.
        """
    )

    def _minimum_radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinimumRadius,
                        self.minimum_radius)

    last_axis_tick_ratio_size = traits.Float(0.3, auto_set=False, enter_set=True, help=\
        """
        Set/Get the ratio between major and minor Last Radial axis ticks
        size
        """
    )

    def _last_axis_tick_ratio_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLastAxisTickRatioSize,
                        self.last_axis_tick_ratio_size)

    radial_axis_title_location = traits.Trait(0, traits.Range(0, 1, enter_set=True, auto_set=False), help=\
        """
        Get/Set the alignement of the radial axes title related to the
        axis. Possible Alignment: VTK_TITLE_BOTTOM, VTK_TITLE_EXTERN
        """
    )

    def _radial_axis_title_location_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRadialAxisTitleLocation,
                        self.radial_axis_title_location)

    polar_axis_title_location = traits.Trait(0, traits.Range(0, 1, enter_set=True, auto_set=False), help=\
        """
        Get/Set the alignement of the polar axes title related to the
        axis. Possible Alignment: VTKTITLE_BOTTOM, VTK_TITLE_EXTERN
        """
    )

    def _polar_axis_title_location_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarAxisTitleLocation,
                        self.polar_axis_title_location)

    polar_label_format = traits.String('%-#6.3g', auto_set=False, enter_set=True, help=\
        """
        Set/Get the format with which to print the polar axis labels.
        """
    )

    def _polar_label_format_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarLabelFormat,
                        self.polar_label_format)

    delta_range_minor = traits.Float(0.5, auto_set=False, enter_set=True, help=\
        """
        Set/Get the step between 2 minor ticks, in range value (values
        displayed on the axis).
        """
    )

    def _delta_range_minor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDeltaRangeMinor,
                        self.delta_range_minor)

    use2d_mode = traits.Int(0, auto_set=False, enter_set=True, help=\
        """
        Enable/Disable labels 2d mode (always facing the camera).
        """
    )

    def _use2d_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUse2DMode,
                        self.use2d_mode)

    range = traits.Array(auto_set=False, enter_set=True, shape=(2,), dtype=float, value=(0.0, 10.0), cols=2, help=\
        """
        
        """
    )

    def _range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRange,
                        self.range)

    maximum_radius = traits.Float(5.0, auto_set=False, enter_set=True, help=\
        """
        Set/Get the maximum radius of the polar coordinates.
        """
    )

    def _maximum_radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumRadius,
                        self.maximum_radius)

    exponent_location = traits.Trait(2, traits.Range(0, 2, enter_set=True, auto_set=False), help=\
        """
        Get/Set the location of the exponent (if any) of the polar axis
        values. Possible location: VTK_EXPONENT_BOTTOM,
        VTK_EXPONENT_EXTERN, VTK_EXPONENT_LABELS
        """
    )

    def _exponent_location_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExponentLocation,
                        self.exponent_location)

    tick_location = traits.Trait(2, traits.Range(0, 2, enter_set=True, auto_set=False), help=\
        """
        Set/Get the location of the ticks. Inside: tick end toward
        positive direction of perpendicular axes. Outside: tick end
        toward negative direction of perpendicular axes.
        """
    )

    def _tick_location_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTickLocation,
                        self.tick_location)

    def _get_polar_axis_title_text_property(self):
        return wrap_vtk(self._vtk_obj.GetPolarAxisTitleTextProperty())
    def _set_polar_axis_title_text_property(self, arg):
        old_val = self._get_polar_axis_title_text_property()
        self._wrap_call(self._vtk_obj.SetPolarAxisTitleTextProperty,
                        deref_vtk(arg))
        self.trait_property_changed('polar_axis_title_text_property', old_val, arg)
    polar_axis_title_text_property = traits.Property(_get_polar_axis_title_text_property, _set_polar_axis_title_text_property, help=\
        """
        Set/Get the polar axis title text property.
        """
    )

    maximum_angle = traits.Float(90.0, auto_set=False, enter_set=True, help=\
        """
        Set/Get the maximum radius of the polar coordinates (in degrees).
        """
    )

    def _maximum_angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumAngle,
                        self.maximum_angle)

    last_radial_axis_major_tick_size = traits.Float(0.1, auto_set=False, enter_set=True, help=\
        """
        Set/Get the size of the major ticks on the last radial axis.
        """
    )

    def _last_radial_axis_major_tick_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLastRadialAxisMajorTickSize,
                        self.last_radial_axis_major_tick_size)

    radial_angle_format = traits.String('%-#3.1f', auto_set=False, enter_set=True, help=\
        """
        String to format angle values displayed on the radial axes.
        """
    )

    def _radial_angle_format_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRadialAngleFormat,
                        self.radial_angle_format)

    def _get_last_radial_axis_text_property(self):
        return wrap_vtk(self._vtk_obj.GetLastRadialAxisTextProperty())
    def _set_last_radial_axis_text_property(self, arg):
        old_val = self._get_last_radial_axis_text_property()
        self._wrap_call(self._vtk_obj.SetLastRadialAxisTextProperty,
                        deref_vtk(arg))
        self.trait_property_changed('last_radial_axis_text_property', old_val, arg)
    last_radial_axis_text_property = traits.Property(_get_last_radial_axis_text_property, _set_last_radial_axis_text_property, help=\
        """
        Set/Get the last radial axis text property.
        """
    )

    def _get_polar_arcs_property(self):
        return wrap_vtk(self._vtk_obj.GetPolarArcsProperty())
    def _set_polar_arcs_property(self, arg):
        old_val = self._get_polar_arcs_property()
        self._wrap_call(self._vtk_obj.SetPolarArcsProperty,
                        deref_vtk(arg))
        self.trait_property_changed('polar_arcs_property', old_val, arg)
    polar_arcs_property = traits.Property(_get_polar_arcs_property, _set_polar_arcs_property, help=\
        """
        Get/Set principal polar arc actor property.
        """
    )

    number_of_polar_axis_ticks = traits.Int(11, auto_set=False, enter_set=True, help=\
        """
        Set/Get a number of ticks that one would like to display along
        polar axis NB: it modifies delta_range_major to correspond to this
        number
        """
    )

    def _number_of_polar_axis_ticks_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfPolarAxisTicks,
                        self.number_of_polar_axis_ticks)

    polar_axis_major_tick_size = traits.Float(0.1, auto_set=False, enter_set=True, help=\
        """
        Set/Get the size of the major ticks on the polar axis.
        """
    )

    def _polar_axis_major_tick_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarAxisMajorTickSize,
                        self.polar_axis_major_tick_size)

    last_radial_axis_major_tick_thickness = traits.Float(1.0, auto_set=False, enter_set=True, help=\
        """
        Set/Get the size of the thickness of last radial axis ticks
        """
    )

    def _last_radial_axis_major_tick_thickness_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLastRadialAxisMajorTickThickness,
                        self.last_radial_axis_major_tick_thickness)

    def _get_polar_axis_property(self):
        return wrap_vtk(self._vtk_obj.GetPolarAxisProperty())
    def _set_polar_axis_property(self, arg):
        old_val = self._get_polar_axis_property()
        self._wrap_call(self._vtk_obj.SetPolarAxisProperty,
                        deref_vtk(arg))
        self.trait_property_changed('polar_axis_property', old_val, arg)
    polar_axis_property = traits.Property(_get_polar_axis_property, _set_polar_axis_property, help=\
        """
        Get/Set polar axis actor properties.
        """
    )

    radial_units = traits.Bool(True, auto_set=False, enter_set=True, help=\
        """
        Default: true
        """
    )

    def _radial_units_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRadialUnits,
                        self.radial_units)

    ratio = traits.Trait(1.0, traits.Range(0.001, 100.0, enter_set=True, auto_set=False), help=\
        """
        Ratio
        """
    )

    def _ratio_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRatio,
                        self.ratio)

    def _get_polar_axis_label_text_property(self):
        return wrap_vtk(self._vtk_obj.GetPolarAxisLabelTextProperty())
    def _set_polar_axis_label_text_property(self, arg):
        old_val = self._get_polar_axis_label_text_property()
        self._wrap_call(self._vtk_obj.SetPolarAxisLabelTextProperty,
                        deref_vtk(arg))
        self.trait_property_changed('polar_axis_label_text_property', old_val, arg)
    polar_axis_label_text_property = traits.Property(_get_polar_axis_label_text_property, _set_polar_axis_label_text_property, help=\
        """
        Set/Get the polar axis labels text property.
        """
    )

    distance_lod_threshold = traits.Trait(0.7, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), help=\
        """
        Set distance LOD threshold [0.0 - 1.0] for titles and labels.
        """
    )

    def _distance_lod_threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDistanceLODThreshold,
                        self.distance_lod_threshold)

    enable_distance_lod = traits.Int(1, auto_set=False, enter_set=True, help=\
        """
        Enable and disable the use of distance based LOD for titles and
        labels.
        """
    )

    def _enable_distance_lod_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnableDistanceLOD,
                        self.enable_distance_lod)

    delta_angle_minor = traits.Float(5.0, auto_set=False, enter_set=True, help=\
        """
        Set/Get the angle between 2 minor ticks on the last arc.
        """
    )

    def _delta_angle_minor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDeltaAngleMinor,
                        self.delta_angle_minor)

    enable_view_angle_lod = traits.Int(1, auto_set=False, enter_set=True, help=\
        """
        Enable and disable the use of view angle based LOD for titles and
        labels.
        """
    )

    def _enable_view_angle_lod_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnableViewAngleLOD,
                        self.enable_view_angle_lod)

    _updateable_traits_ = \
    (('polar_title_visibility', 'GetPolarTitleVisibility'),
    ('polar_label_format', 'GetPolarLabelFormat'),
    ('last_axis_tick_ratio_size', 'GetLastAxisTickRatioSize'), ('range',
    'GetRange'), ('screen_size', 'GetScreenSize'), ('use2d_mode',
    'GetUse2DMode'), ('enable_distance_lod', 'GetEnableDistanceLOD'),
    ('arc_tick_ratio_size', 'GetArcTickRatioSize'), ('exponent_location',
    'GetExponentLocation'), ('delta_range_major', 'GetDeltaRangeMajor'),
    ('polar_axis_title', 'GetPolarAxisTitle'), ('force_translucent',
    'GetForceTranslucent'), ('polar_arcs_visibility',
    'GetPolarArcsVisibility'), ('polar_tick_visibility',
    'GetPolarTickVisibility'), ('pole', 'GetPole'), ('log', 'GetLog'),
    ('smallest_visible_polar_angle', 'GetSmallestVisiblePolarAngle'),
    ('arc_major_tick_thickness', 'GetArcMajorTickThickness'),
    ('draw_polar_arcs_gridlines', 'GetDrawPolarArcsGridlines'),
    ('draw_radial_gridlines', 'GetDrawRadialGridlines'),
    ('polar_axis_major_tick_size', 'GetPolarAxisMajorTickSize'),
    ('polar_axis_major_tick_thickness', 'GetPolarAxisMajorTickThickness'),
    ('force_opaque', 'GetForceOpaque'), ('axis_minor_tick_visibility',
    'GetAxisMinorTickVisibility'),
    ('last_radial_axis_major_tick_thickness',
    'GetLastRadialAxisMajorTickThickness'), ('view_angle_lod_threshold',
    'GetViewAngleLODThreshold'), ('delta_angle_minor',
    'GetDeltaAngleMinor'), ('maximum_angle', 'GetMaximumAngle'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('render_time_multiplier', 'GetRenderTimeMultiplier'),
    ('arc_tick_visibility', 'GetArcTickVisibility'), ('delta_angle_major',
    'GetDeltaAngleMajor'), ('dragable', 'GetDragable'),
    ('radial_title_visibility', 'GetRadialTitleVisibility'),
    ('estimated_render_time', 'GetEstimatedRenderTime'),
    ('radial_axes_visibility', 'GetRadialAxesVisibility'),
    ('delta_range_minor', 'GetDeltaRangeMinor'), ('radial_units',
    'GetRadialUnits'), ('distance_lod_threshold',
    'GetDistanceLODThreshold'), ('origin', 'GetOrigin'),
    ('arc_tick_ratio_thickness', 'GetArcTickRatioThickness'),
    ('delta_angle_radial_axes', 'GetDeltaAngleRadialAxes'), ('use_bounds',
    'GetUseBounds'), ('number_of_radial_axes', 'GetNumberOfRadialAxes'),
    ('minimum_radius', 'GetMinimumRadius'), ('number_of_polar_axis_ticks',
    'GetNumberOfPolarAxisTicks'), ('polar_axis_title_location',
    'GetPolarAxisTitleLocation'), ('last_axis_tick_ratio_thickness',
    'GetLastAxisTickRatioThickness'), ('radial_axis_title_location',
    'GetRadialAxisTitleLocation'), ('polar_axis_visibility',
    'GetPolarAxisVisibility'), ('maximum_radius', 'GetMaximumRadius'),
    ('polar_label_visibility', 'GetPolarLabelVisibility'), ('position',
    'GetPosition'), ('auto_scale_radius', 'GetAutoScaleRadius'), ('scale',
    'GetScale'), ('tick_location', 'GetTickLocation'), ('pickable',
    'GetPickable'), ('arc_minor_tick_visibility',
    'GetArcMinorTickVisibility'), ('minimum_angle', 'GetMinimumAngle'),
    ('orientation', 'GetOrientation'), ('arc_major_tick_size',
    'GetArcMajorTickSize'), ('last_radial_axis_major_tick_size',
    'GetLastRadialAxisMajorTickSize'), ('auto_subdivide_polar_axis',
    'GetAutoSubdividePolarAxis'), ('debug', 'GetDebug'), ('visibility',
    'GetVisibility'), ('radial_axes_origin_to_polar_axis',
    'GetRadialAxesOriginToPolarAxis'), ('reference_count',
    'GetReferenceCount'), ('enable_view_angle_lod',
    'GetEnableViewAngleLOD'), ('axis_tick_visibility',
    'GetAxisTickVisibility'), ('polar_axis_tick_ratio_size',
    'GetPolarAxisTickRatioSize'), ('radial_angle_format',
    'GetRadialAngleFormat'), ('arc_ticks_origin_to_polar_axis',
    'GetArcTicksOriginToPolarAxis'), ('ratio', 'GetRatio'),
    ('polar_axis_tick_ratio_thickness', 'GetPolarAxisTickRatioThickness'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['arc_minor_tick_visibility', 'arc_tick_visibility',
    'arc_ticks_origin_to_polar_axis', 'auto_subdivide_polar_axis',
    'axis_minor_tick_visibility', 'axis_tick_visibility', 'debug',
    'dragable', 'draw_polar_arcs_gridlines', 'draw_radial_gridlines',
    'force_opaque', 'force_translucent', 'global_warning_display', 'log',
    'pickable', 'polar_arcs_visibility', 'polar_axis_visibility',
    'polar_label_visibility', 'polar_tick_visibility',
    'polar_title_visibility', 'radial_axes_origin_to_polar_axis',
    'radial_axes_visibility', 'radial_title_visibility', 'use_bounds',
    'visibility', 'arc_major_tick_size', 'arc_major_tick_thickness',
    'arc_tick_ratio_size', 'arc_tick_ratio_thickness',
    'auto_scale_radius', 'delta_angle_major', 'delta_angle_minor',
    'delta_angle_radial_axes', 'delta_range_major', 'delta_range_minor',
    'distance_lod_threshold', 'enable_distance_lod',
    'enable_view_angle_lod', 'estimated_render_time', 'exponent_location',
    'last_axis_tick_ratio_size', 'last_axis_tick_ratio_thickness',
    'last_radial_axis_major_tick_size',
    'last_radial_axis_major_tick_thickness', 'maximum_angle',
    'maximum_radius', 'minimum_angle', 'minimum_radius',
    'number_of_polar_axis_ticks', 'number_of_radial_axes', 'orientation',
    'origin', 'polar_axis_major_tick_size',
    'polar_axis_major_tick_thickness', 'polar_axis_tick_ratio_size',
    'polar_axis_tick_ratio_thickness', 'polar_axis_title',
    'polar_axis_title_location', 'polar_label_format', 'pole', 'position',
    'radial_angle_format', 'radial_axis_title_location', 'radial_units',
    'range', 'ratio', 'render_time_multiplier', 'scale', 'screen_size',
    'smallest_visible_polar_angle', 'tick_location', 'use2d_mode',
    'view_angle_lod_threshold'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PolarAxesActor, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PolarAxesActor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['arc_minor_tick_visibility', 'arc_tick_visibility',
            'arc_ticks_origin_to_polar_axis', 'auto_subdivide_polar_axis',
            'axis_minor_tick_visibility', 'axis_tick_visibility',
            'draw_polar_arcs_gridlines', 'draw_radial_gridlines', 'force_opaque',
            'force_translucent', 'log', 'polar_arcs_visibility',
            'polar_axis_visibility', 'polar_label_visibility',
            'polar_tick_visibility', 'polar_title_visibility',
            'radial_axes_origin_to_polar_axis', 'radial_axes_visibility',
            'radial_title_visibility', 'use_bounds', 'visibility'], [],
            ['arc_major_tick_size', 'arc_major_tick_thickness',
            'arc_tick_ratio_size', 'arc_tick_ratio_thickness',
            'auto_scale_radius', 'delta_angle_major', 'delta_angle_minor',
            'delta_angle_radial_axes', 'delta_range_major', 'delta_range_minor',
            'distance_lod_threshold', 'enable_distance_lod',
            'enable_view_angle_lod', 'estimated_render_time', 'exponent_location',
            'last_axis_tick_ratio_size', 'last_axis_tick_ratio_thickness',
            'last_radial_axis_major_tick_size',
            'last_radial_axis_major_tick_thickness', 'maximum_angle',
            'maximum_radius', 'minimum_angle', 'minimum_radius',
            'number_of_polar_axis_ticks', 'number_of_radial_axes', 'orientation',
            'origin', 'polar_axis_major_tick_size',
            'polar_axis_major_tick_thickness', 'polar_axis_tick_ratio_size',
            'polar_axis_tick_ratio_thickness', 'polar_axis_title',
            'polar_axis_title_location', 'polar_label_format', 'pole', 'position',
            'radial_angle_format', 'radial_axis_title_location', 'radial_units',
            'range', 'ratio', 'render_time_multiplier', 'scale', 'screen_size',
            'smallest_visible_polar_angle', 'tick_location', 'use2d_mode',
            'view_angle_lod_threshold']),
            title='Edit PolarAxesActor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PolarAxesActor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

