# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.control_points_item import ControlPointsItem


class PiecewiseControlPointsItem(ControlPointsItem):
    """
    PiecewiseControlPointsItem - Control points for
    PiecewiseFunction.
    
    Superclass: ControlPointsItem
    
    PiecewiseControlPointsItem draws the control points of a
    PiecewiseFunction.
    @sa
    ControlPointsItem PiecewiseFunctionItem
    CompositeTransferFunctionItem
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPiecewiseControlPointsItem, obj, update, **traits)
    
    def _get_piecewise_function(self):
        return wrap_vtk(self._vtk_obj.GetPiecewiseFunction())
    def _set_piecewise_function(self, arg):
        old_val = self._get_piecewise_function()
        self._wrap_call(self._vtk_obj.SetPiecewiseFunction,
                        deref_vtk(arg))
        self.trait_property_changed('piecewise_function', old_val, arg)
    piecewise_function = traits.Property(_get_piecewise_function, _set_piecewise_function, help=\
        """
        Get the piecewise function
        """
    )

    stroke_mode = traits.Bool(False, auto_set=False, enter_set=True, help=\
        """
        Controls whether or not control points are drawn (true) or
        clicked and moved (false). False by default.
        """
    )

    def _stroke_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStrokeMode,
                        self.stroke_mode)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, help=\
        """
        Get the input table used by the plot.
        """
    )

    _updateable_traits_ = \
    (('show_labels', 'GetShowLabels'), ('switch_points_mode',
    'GetSwitchPointsMode'), ('width', 'GetWidth'), ('selectable',
    'GetSelectable'), ('end_points_removable', 'GetEndPointsRemovable'),
    ('label', 'GetLabel'), ('user_bounds', 'GetUserBounds'),
    ('current_point', 'GetCurrentPoint'), ('opacity', 'GetOpacity'),
    ('legend_visibility', 'GetLegendVisibility'),
    ('use_index_for_x_series', 'GetUseIndexForXSeries'), ('visible',
    'GetVisible'), ('tooltip_notation', 'GetTooltipNotation'), ('debug',
    'GetDebug'), ('tooltip_precision', 'GetTooltipPrecision'),
    ('reference_count', 'GetReferenceCount'), ('screen_point_radius',
    'GetScreenPointRadius'), ('tooltip_label_format',
    'GetTooltipLabelFormat'), ('end_points_x_movable',
    'GetEndPointsXMovable'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('end_points_y_movable',
    'GetEndPointsYMovable'), ('valid_bounds', 'GetValidBounds'),
    ('stroke_mode', 'GetStrokeMode'), ('label_format', 'GetLabelFormat'),
    ('interactive', 'GetInteractive'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'legend_visibility',
    'selectable', 'current_point', 'end_points_removable',
    'end_points_x_movable', 'end_points_y_movable', 'interactive',
    'label', 'label_format', 'opacity', 'screen_point_radius',
    'show_labels', 'stroke_mode', 'switch_points_mode',
    'tooltip_label_format', 'tooltip_notation', 'tooltip_precision',
    'use_index_for_x_series', 'user_bounds', 'valid_bounds', 'visible',
    'width'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PiecewiseControlPointsItem, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PiecewiseControlPointsItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['legend_visibility', 'selectable'], [], ['current_point',
            'end_points_removable', 'end_points_x_movable',
            'end_points_y_movable', 'interactive', 'label', 'label_format',
            'opacity', 'screen_point_radius', 'show_labels', 'stroke_mode',
            'switch_points_mode', 'tooltip_label_format', 'tooltip_notation',
            'tooltip_precision', 'use_index_for_x_series', 'user_bounds',
            'valid_bounds', 'visible', 'width']),
            title='Edit PiecewiseControlPointsItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PiecewiseControlPointsItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

