# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.widget_representation import WidgetRepresentation


class AffineRepresentation(WidgetRepresentation):
    """
    AffineRepresentation - abstract class for representing affine
    transformation widgets
    
    Superclass: WidgetRepresentation
    
    This class defines an API for affine transformation widget
    representations. These representations interact with AffineWidget.
    The basic functionality of the affine representation is to maintain a
    transformation matrix.
    
    This class may be subclassed so that alternative representations can
    be created.  The class defines an API and a default implementation
    that the AffineWidget interacts with to render itself in the
    scene.
    
    @warning
    The separation of the widget event handling and representation
    enables users and developers to create new appearances for the
    widget. It also facilitates parallel processing, where the client
    application handles events, and remote representations of the widget
    are slaves to the client (and do not handle events).
    
    @sa
    AffineWidget WidgetRepresentation AbstractWidget
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAffineRepresentation, obj, update, **traits)
    
    tolerance = traits.Trait(3, traits.Range(1, 100, enter_set=True, auto_set=False), help=\
        """
        The tolerance representing the distance to the widget (in pixels)
        in which the cursor is considered near enough to the widget to be
        active.
        """
    )

    def _tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTolerance,
                        self.tolerance)

    def get_transform(self, *args):
        """
        V.get_transform(Transform)
        C++: virtual void GetTransform(Transform *t)
        Retrieve a linear transform characterizing the affine
        transformation generated by this widget. This method copies its
        internal transform into the transform provided. The transform is
        relative to the initial placement of the representation (i.e.,
        when place_widget() is invoked).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetTransform, *my_args)
        return ret

    _updateable_traits_ = \
    (('need_to_render', 'GetNeedToRender'), ('estimated_render_time',
    'GetEstimatedRenderTime'), ('use_bounds', 'GetUseBounds'), ('debug',
    'GetDebug'), ('visibility', 'GetVisibility'), ('tolerance',
    'GetTolerance'), ('pickable', 'GetPickable'), ('reference_count',
    'GetReferenceCount'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('picking_managed', 'GetPickingManaged'),
    ('place_factor', 'GetPlaceFactor'), ('render_time_multiplier',
    'GetRenderTimeMultiplier'), ('dragable', 'GetDragable'),
    ('handle_size', 'GetHandleSize'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'dragable', 'global_warning_display', 'need_to_render',
    'pickable', 'picking_managed', 'use_bounds', 'visibility',
    'estimated_render_time', 'handle_size', 'place_factor',
    'render_time_multiplier', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AffineRepresentation, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AffineRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['need_to_render', 'picking_managed', 'use_bounds',
            'visibility'], [], ['estimated_render_time', 'handle_size',
            'place_factor', 'render_time_multiplier', 'tolerance']),
            title='Edit AffineRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AffineRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

