# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.parametric_function import ParametricFunction


class ParametricBohemianDome(ParametricFunction):
    """
    ParametricBohemianDome - Generate a Bohemian dome.
    
    Superclass: ParametricFunction
    
    ParametricBohemianDome generates a parametric Bohemian dome. The
    Bohemian dome is a quartic surface, and is described in much better
    detail at <a
    href="https://www.math.hmc.edu/math142-01/mellon/curves_and_surfaces/surfaces/bohdom.html"
    >HMC page.
    @warning
    I haven't set any restrictions on the A, B, or C values.@par Thanks:
    Tim Meehan
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkParametricBohemianDome, obj, update, **traits)
    
    a = traits.Float(0.5, auto_set=False, enter_set=True, help=\
        """
        Construct a Bohemian dome surface with the following parameters:
        """
    )

    def _a_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetA,
                        self.a)

    c = traits.Float(1.0, auto_set=False, enter_set=True, help=\
        """
        
        """
    )

    def _c_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetC,
                        self.c)

    b = traits.Float(1.5, auto_set=False, enter_set=True, help=\
        """
        
        """
    )

    def _b_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetB,
                        self.b)

    _updateable_traits_ = \
    (('a', 'GetA'), ('c', 'GetC'), ('clockwise_ordering',
    'GetClockwiseOrdering'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'),
    ('derivatives_available', 'GetDerivativesAvailable'), ('join_w',
    'GetJoinW'), ('join_v', 'GetJoinV'), ('join_u', 'GetJoinU'),
    ('twist_w', 'GetTwistW'), ('twist_v', 'GetTwistV'), ('twist_u',
    'GetTwistU'), ('b', 'GetB'), ('minimum_u', 'GetMinimumU'),
    ('minimum_v', 'GetMinimumV'), ('minimum_w', 'GetMinimumW'), ('debug',
    'GetDebug'), ('maximum_v', 'GetMaximumV'), ('maximum_w',
    'GetMaximumW'), ('maximum_u', 'GetMaximumU'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['clockwise_ordering', 'debug', 'derivatives_available',
    'global_warning_display', 'join_u', 'join_v', 'join_w', 'twist_u',
    'twist_v', 'twist_w', 'a', 'b', 'c', 'maximum_u', 'maximum_v',
    'maximum_w', 'minimum_u', 'minimum_v', 'minimum_w'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ParametricBohemianDome, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ParametricBohemianDome properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['clockwise_ordering', 'derivatives_available', 'join_u',
            'join_v', 'join_w', 'twist_u', 'twist_v', 'twist_w'], [], ['a', 'b',
            'c', 'maximum_u', 'maximum_v', 'maximum_w', 'minimum_u', 'minimum_v',
            'minimum_w']),
            title='Edit ParametricBohemianDome properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ParametricBohemianDome properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

