# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.color_transfer_control_points_item import ColorTransferControlPointsItem


class CompositeControlPointsItem(ColorTransferControlPointsItem):
    """
    CompositeControlPointsItem - Control points for
    CompositeFunction.
    
    Superclass: ColorTransferControlPointsItem
    
    CompositeControlPointsItem draws the control points of a
    PiecewiseFunction and a ColorTransferFunction.
    @sa
    ControlPointsItem ColorTransferControlPointsItem
    CompositeTransferFunctionItem PiecewisePointHandleItem
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCompositeControlPointsItem, obj, update, **traits)
    
    def _get_color_transfer_function(self):
        return wrap_vtk(self._vtk_obj.GetColorTransferFunction())
    def _set_color_transfer_function(self, arg):
        old_val = self._get_color_transfer_function()
        self._wrap_call(self._vtk_obj.SetColorTransferFunction,
                        deref_vtk(arg))
        self.trait_property_changed('color_transfer_function', old_val, arg)
    color_transfer_function = traits.Property(_get_color_transfer_function, _set_color_transfer_function, help=\
        """
        Get the piecewise function
        """
    )

    points_function = traits.Int(3, auto_set=False, enter_set=True, help=\
        """
        points_function controls wether the points represent the
        color_transfer_function, opacity_transfer_function or both. If
        color_points_function, only the points of the color_transfer
        function are used. If opacity_points_function, only the points of
        the Opacity function are used If color_and_opacity_points_function,
        the points of both functions are shared by both functions.
        color_and_opacity_points_function by default. Note: Set the mode
        before the functions are set. color_points_function is not fully
        supported.
        """
    )

    def _points_function_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPointsFunction,
                        self.points_function)

    def _get_opacity_function(self):
        return wrap_vtk(self._vtk_obj.GetOpacityFunction())
    def _set_opacity_function(self, arg):
        old_val = self._get_opacity_function()
        self._wrap_call(self._vtk_obj.SetOpacityFunction,
                        deref_vtk(arg))
        self.trait_property_changed('opacity_function', old_val, arg)
    opacity_function = traits.Property(_get_opacity_function, _set_opacity_function, help=\
        """
        Utility function that calls set_piecewise_function()
        """
    )

    use_opacity_point_handles = traits.Bool(False, auto_set=False, enter_set=True, help=\
        """
        If use_opacity_point_handles is true, when the current point is
        double clicked, a PiecewisePointHandleItem will show up so
        that the sharpness and mid point can be adjusted in the scene
        with those handles False by default.
        """
    )

    def _use_opacity_point_handles_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseOpacityPointHandles,
                        self.use_opacity_point_handles)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, help=\
        """
        Get the input table used by the plot.
        """
    )

    _updateable_traits_ = \
    (('opacity', 'GetOpacity'), ('switch_points_mode',
    'GetSwitchPointsMode'), ('end_points_removable',
    'GetEndPointsRemovable'), ('points_function', 'GetPointsFunction'),
    ('color_fill', 'GetColorFill'), ('user_bounds', 'GetUserBounds'),
    ('use_opacity_point_handles', 'GetUseOpacityPointHandles'),
    ('visible', 'GetVisible'), ('tooltip_notation', 'GetTooltipNotation'),
    ('end_points_y_movable', 'GetEndPointsYMovable'),
    ('end_points_x_movable', 'GetEndPointsXMovable'), ('selectable',
    'GetSelectable'), ('current_point', 'GetCurrentPoint'),
    ('screen_point_radius', 'GetScreenPointRadius'), ('show_labels',
    'GetShowLabels'), ('use_index_for_x_series', 'GetUseIndexForXSeries'),
    ('reference_count', 'GetReferenceCount'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('legend_visibility',
    'GetLegendVisibility'), ('label_format', 'GetLabelFormat'),
    ('valid_bounds', 'GetValidBounds'), ('label', 'GetLabel'), ('width',
    'GetWidth'), ('debug', 'GetDebug'), ('tooltip_precision',
    'GetTooltipPrecision'), ('tooltip_label_format',
    'GetTooltipLabelFormat'), ('interactive', 'GetInteractive'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'legend_visibility',
    'selectable', 'color_fill', 'current_point', 'end_points_removable',
    'end_points_x_movable', 'end_points_y_movable', 'interactive',
    'label', 'label_format', 'opacity', 'points_function',
    'screen_point_radius', 'show_labels', 'switch_points_mode',
    'tooltip_label_format', 'tooltip_notation', 'tooltip_precision',
    'use_index_for_x_series', 'use_opacity_point_handles', 'user_bounds',
    'valid_bounds', 'visible', 'width'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CompositeControlPointsItem, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CompositeControlPointsItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['legend_visibility', 'selectable'], [], ['color_fill',
            'current_point', 'end_points_removable', 'end_points_x_movable',
            'end_points_y_movable', 'interactive', 'label', 'label_format',
            'opacity', 'points_function', 'screen_point_radius', 'show_labels',
            'switch_points_mode', 'tooltip_label_format', 'tooltip_notation',
            'tooltip_precision', 'use_index_for_x_series',
            'use_opacity_point_handles', 'user_bounds', 'valid_bounds', 'visible',
            'width']),
            title='Edit CompositeControlPointsItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CompositeControlPointsItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

