# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.parametric_function import ParametricFunction


class ParametricTorus(ParametricFunction):
    """
    ParametricTorus - Generate a torus.
    
    Superclass: ParametricFunction
    
    ParametricTorus generates a torus.
    
    For further information about this surface, please consult the
    technical description "Parametric surfaces" in
    http://www.vtk.org/publications in the "VTK Technical Documents"
    section in the VTk.org web pages.
    
    @par Thanks: Andrew Maclean andrew.amaclean@gmail.com for creating
    and contributing the class.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkParametricTorus, obj, update, **traits)
    
    ring_radius = traits.Float(1.0, enter_set=True, auto_set=False, help=\
        """
        Set/Get the radius from the center to the middle of the ring of
        the torus. Default is 1.0.
        """
    )

    def _ring_radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRingRadius,
                        self.ring_radius)

    cross_section_radius = traits.Float(0.5, enter_set=True, auto_set=False, help=\
        """
        Set/Get the radius of the cross section of ring of the torus.
        Default is 0.5.
        """
    )

    def _cross_section_radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCrossSectionRadius,
                        self.cross_section_radius)

    _updateable_traits_ = \
    (('twist_w', 'GetTwistW'), ('reference_count', 'GetReferenceCount'),
    ('maximum_w', 'GetMaximumW'), ('twist_u', 'GetTwistU'),
    ('ring_radius', 'GetRingRadius'), ('derivatives_available',
    'GetDerivativesAvailable'), ('join_v', 'GetJoinV'), ('debug',
    'GetDebug'), ('maximum_v', 'GetMaximumV'), ('maximum_u',
    'GetMaximumU'), ('minimum_v', 'GetMinimumV'), ('minimum_u',
    'GetMinimumU'), ('cross_section_radius', 'GetCrossSectionRadius'),
    ('twist_v', 'GetTwistV'), ('clockwise_ordering',
    'GetClockwiseOrdering'), ('join_w', 'GetJoinW'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('join_u',
    'GetJoinU'), ('minimum_w', 'GetMinimumW'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['clockwise_ordering', 'debug', 'derivatives_available',
    'global_warning_display', 'join_u', 'join_v', 'join_w', 'twist_u',
    'twist_v', 'twist_w', 'cross_section_radius', 'maximum_u',
    'maximum_v', 'maximum_w', 'minimum_u', 'minimum_v', 'minimum_w',
    'ring_radius'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ParametricTorus, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ParametricTorus properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['clockwise_ordering', 'derivatives_available', 'join_u',
            'join_v', 'join_w', 'twist_u', 'twist_v', 'twist_w'], [],
            ['cross_section_radius', 'maximum_u', 'maximum_v', 'maximum_w',
            'minimum_u', 'minimum_v', 'minimum_w', 'ring_radius']),
            title='Edit ParametricTorus properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ParametricTorus properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

