# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

from tvtk.tvtk_classes.threaded_image_algorithm import ThreadedImageAlgorithm


class ImageMagnify(ThreadedImageAlgorithm):
    """
    ImageMagnify - magnify an image by an integer value
    
    Superclass: ThreadedImageAlgorithm
    
    ImageMagnify maps each pixel of the input onto a nxmx... region of
    the output.  Location (0,0,...) remains in the same place. The
    magnification occurs via pixel replication, or if Interpolate is on,
    by bilinear interpolation. Initially, interpolation is off and
    magnification factors are set to 1 in all directions.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImageMagnify, obj, update, **traits)
    
    interpolate = tvtk_base.false_bool_trait(help=\
        """
        Turn interpolation on and off (pixel replication is used when
        off). Initially, interpolation is off.
        """
    )

    def _interpolate_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolate,
                        self.interpolate_)

    magnification_factors = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype=int, value=(1, 1, 1), cols=3, help=\
        """
        
        """
    )

    def _magnification_factors_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMagnificationFactors,
                        self.magnification_factors)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            help="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('reference_count', 'GetReferenceCount'), ('progress_text',
    'GetProgressText'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('minimum_piece_size', 'GetMinimumPieceSize'),
    ('global_default_enable_smp', 'GetGlobalDefaultEnableSMP'),
    ('abort_execute', 'GetAbortExecute'), ('enable_smp', 'GetEnableSMP'),
    ('debug', 'GetDebug'), ('desired_bytes_per_piece',
    'GetDesiredBytesPerPiece'), ('number_of_threads',
    'GetNumberOfThreads'), ('magnification_factors',
    'GetMagnificationFactors'), ('progress', 'GetProgress'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('split_mode',
    'GetSplitMode'), ('interpolate', 'GetInterpolate'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display', 'interpolate',
    'release_data_flag', 'split_mode', 'desired_bytes_per_piece',
    'enable_smp', 'global_default_enable_smp', 'magnification_factors',
    'minimum_piece_size', 'number_of_threads', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImageMagnify, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ImageMagnify properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['interpolate'], ['split_mode'], ['desired_bytes_per_piece',
            'enable_smp', 'global_default_enable_smp', 'magnification_factors',
            'minimum_piece_size', 'number_of_threads']),
            title='Edit ImageMagnify properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImageMagnify properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

