/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.LAPACKkernel;
import no.uib.cipr.matrix.LowerSymmDenseMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SymmEVD;
import no.uib.cipr.matrix.UpperSymmDenseMatrix;

public class SymmDenseEVD
extends SymmEVD {
    private final double[] work;
    private final int[] iwork;
    private final BLASkernel.UpLo uplo;
    private final LAPACKkernel.JobEigRange range;
    private final int[] isuppz;
    private final double abstol;

    public SymmDenseEVD(int n, boolean upper) {
        this(n, upper, true, Interface.lapack().lamch("Safe minimum"));
    }

    public SymmDenseEVD(int n, boolean upper, double abstol) {
        this(n, upper, true, abstol);
    }

    public SymmDenseEVD(int n, boolean upper, boolean vectors) {
        this(n, upper, vectors, Interface.lapack().lamch("Safe minimum"));
    }

    public SymmDenseEVD(int n, boolean upper, boolean vectors, double abstol) {
        super(n, vectors);
        this.abstol = abstol;
        this.uplo = upper ? BLASkernel.UpLo.Upper : BLASkernel.UpLo.Lower;
        this.range = LAPACKkernel.JobEigRange.All;
        this.isuppz = new int[2 * Math.max(1, n)];
        double[] worksize = new double[1];
        int[] iworksize = new int[1];
        int info = Interface.lapack().syevr(this.job, this.range, this.uplo, n, new double[0], 0.0, 0.0, 0, 0, abstol, new int[1], new double[0], new double[0], this.isuppz, worksize, -1, iworksize, -1);
        int lwork = 0;
        int liwork = 0;
        if (info != 0) {
            lwork = 26 * n;
            liwork = 10 * n;
        } else {
            lwork = (int)worksize[0];
            liwork = iworksize[0];
        }
        lwork = Math.max(1, lwork);
        liwork = Math.max(1, liwork);
        this.work = new double[lwork];
        this.iwork = new int[liwork];
    }

    public static SymmDenseEVD factorize(Matrix A) throws NotConvergedException {
        return new SymmDenseEVD(A.numRows(), true).factor(new UpperSymmDenseMatrix(A));
    }

    public SymmDenseEVD factor(LowerSymmDenseMatrix A) throws NotConvergedException {
        if (this.uplo != BLASkernel.UpLo.Lower) {
            throw new IllegalArgumentException("Eigenvalue computer configured for lower-symmetrical matrices");
        }
        return this.factor(A, A.getData());
    }

    public SymmDenseEVD factor(UpperSymmDenseMatrix A) throws NotConvergedException {
        if (this.uplo != BLASkernel.UpLo.Upper) {
            throw new IllegalArgumentException("Eigenvalue computer configured for upper-symmetrical matrices");
        }
        return this.factor(A, A.getData());
    }

    private SymmDenseEVD factor(Matrix A, double[] data) throws NotConvergedException {
        if (A.numRows() != this.n) {
            throw new IllegalArgumentException("A.numRows() != n");
        }
        int info = Interface.lapack().syevr(this.job, this.range, this.uplo, this.n, data, 0.0, 0.0, 0, 0, this.abstol, new int[1], this.w, this.job == LAPACKkernel.JobEig.All ? this.Z.getData() : new double[]{}, this.isuppz, this.work, this.work.length, this.iwork, this.iwork.length);
        if (info > 0) {
            throw new NotConvergedException(NotConvergedException.Reason.Iterations);
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return this;
    }
}

