/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.FieldCleaner;
import cc.mallet.extract.FieldComparator;
import cc.mallet.extract.LabeledSpan;
import cc.mallet.types.Label;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class Field {
    private Label name;
    private List values = new ArrayList();
    private List allSpans = new ArrayList();

    public Field(LabeledSpan span) {
        this.name = span.getLabel();
        this.addFiller(span);
    }

    public Label getName() {
        return this.name;
    }

    public int numValues() {
        return this.values.size();
    }

    public String value(int i) {
        return (String)this.values.get(i);
    }

    public LabeledSpan span(int i) {
        return (LabeledSpan)this.allSpans.get(i);
    }

    public void addFiller(LabeledSpan span) {
        if (this.name != span.getLabel()) {
            throw new IllegalArgumentException("Attempt to fill slot " + this.name + " with a span of type " + span.getLabel());
        }
        this.values.add(span.getText());
        this.allSpans.add(span);
    }

    void cleanField(FieldCleaner cleaner) {
        ListIterator<String> it = this.values.listIterator();
        while (it.hasNext()) {
            String rawValue = (String)it.next();
            it.remove();
            it.add(cleaner.cleanFieldValue(rawValue));
        }
    }

    public boolean isValue(String filler) {
        return this.values.contains(filler);
    }

    public boolean isValue(String filler, FieldComparator comper) {
        for (String s : this.values) {
            if (!comper.matches(filler, s)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("FIELD NAME: ");
        buf.append(this.name);
        buf.append("\n");
        for (String s : this.values) {
            buf.append("FILLER:");
            buf.append(s);
            buf.append("\n");
        }
        return buf.toString();
    }
}

