# Config file for the magics package
# Defines the following variables:
#
#  magics_FEATURES       - list of enabled features
#  magics_VERSION        - version of the package
#  magics_GIT_SHA1       - Git revision of the package
#  magics_GIT_SHA1_SHORT - short Git revision of the package
#


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was project-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

### computed paths
set_and_check(magics_CMAKE_DIR "${PACKAGE_PREFIX_DIR}/lib/cmake/magics")
set_and_check(magics_BASE_DIR "${PACKAGE_PREFIX_DIR}/.")
if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
  set(MAGICS_CMAKE_DIR ${magics_CMAKE_DIR})
  set(MAGICS_BASE_DIR ${magics_BASE_DIR})
endif()

### export version info
set(magics_VERSION           "4.2.0")
set(magics_GIT_SHA1          "")
set(magics_GIT_SHA1_SHORT    "")

if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
  set(MAGICS_VERSION           "4.2.0" )
  set(MAGICS_GIT_SHA1          "" )
  set(MAGICS_GIT_SHA1_SHORT    "" )
endif()

### has this configuration been exported from a build tree?
set(magics_IS_BUILD_DIR_EXPORT OFF)
if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
  set(MAGICS_IS_BUILD_DIR_EXPORT ${magics_IS_BUILD_DIR_EXPORT})
endif()

### include the <project>-import.cmake file if there is one
if(EXISTS ${magics_CMAKE_DIR}/magics-import.cmake)
  set(magics_IMPORT_FILE "${magics_CMAKE_DIR}/magics-import.cmake")
  include(${magics_IMPORT_FILE})
endif()

### handle third-party dependencies
if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
  set(MAGICS_LIBRARIES         "MagPlus")
  set(MAGICS_TPLS              "eccodes;spot;EXPAT;NetCDF;Proj4;zlib;PangoCairo" )

  include(${CMAKE_CURRENT_LIST_FILE}.tpls OPTIONAL)
endif()

### insert definitions for IMPORTED targets
if(NOT magics_BINARY_DIR)
  find_file(magics_TARGETS_FILE
    NAMES magics-targets.cmake
    HINTS ${magics_CMAKE_DIR}
    NO_DEFAULT_PATH)
  if(magics_TARGETS_FILE)
    include(${magics_TARGETS_FILE})
  endif()
endif()

### publish this file as imported
if( DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT )
  set(magics_IMPORT_FILE ${CMAKE_CURRENT_LIST_FILE})
  mark_as_advanced(magics_IMPORT_FILE)
  set(MAGICS_IMPORT_FILE ${CMAKE_CURRENT_LIST_FILE})
  mark_as_advanced(MAGICS_IMPORT_FILE)
endif()

### export features and check requirements
set(magics_FEATURES "TESTS;PYTHON;CAIRO;NETCDF")
if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
  set(MAGICS_FEATURES ${magics_FEATURES})
endif()
foreach(_f ${magics_FEATURES})
  set(magics_${_f}_FOUND 1)
  set(magics_HAVE_${_f} 1)
  if(DEFINED ECBUILD_2_COMPAT AND ECBUILD_2_COMPAT)
    set(MAGICS_HAVE_${_f} 1)
  endif()
endforeach()
check_required_components(magics)
