# Config file for the magics package
# Defines the following variables:
#
#  MAGICS_INCLUDE_DIRS   - include directories
#  MAGICS_DEFINITIONS    - preprocessor definitions
#  MAGICS_LIBRARIES      - libraries to link against
#  MAGICS_FEATURES       - list of enabled features
#  MAGICS_VERSION        - version of the package
#  MAGICS_GIT_SHA1       - Git revision of the package
#  MAGICS_GIT_SHA1_SHORT - short Git revision of the package
#
# Also defines magics third-party library dependencies:
#  MAGICS_TPLS             - package names of  third-party library dependencies
#  MAGICS_TPL_INCLUDE_DIRS - include directories
#  MAGICS_TPL_DEFINITIONS  - preprocessor definitions
#  MAGICS_TPL_LIBRARIES    - libraries to link against

### compute paths

get_filename_component(MAGICS_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

set( MAGICS_SELF_INCLUDE_DIRS "${MAGICS_CMAKE_DIR}/../../../include/magics" )
set( MAGICS_SELF_DEFINITIONS  "" )
set( MAGICS_SELF_LIBRARIES    "MagPlus" )

set( MAGICS_TPLS              "eccodes;spot;EXPAT;NetCDF;Proj4;PangoCairo" )
set( MAGICS_TPL_INCLUDE_DIRS  "D:/bld/magics_1559240523318/_h_env/Library/include;D:/bld/magics_1559240523318/_h_env/Library/include/pango-1.0" )
set( MAGICS_TPL_DEFINITIONS   "" )
set( MAGICS_TPL_LIBRARIES     "eccodes;D:/bld/magics_1559240523318/_h_env/Library/lib/expat.lib;debug;optimized;D:/bld/magics_1559240523318/_h_env/Library/lib/netcdf.lib;D:/bld/magics_1559240523318/_h_env/Library/lib/hdf5.lib;D:/bld/magics_1559240523318/_h_env/Library/lib/proj.lib;D:/bld/magics_1559240523318/_h_env/Library/lib/pango-1.0.lib;D:/bld/magics_1559240523318/_h_env/Library/lib/pangocairo-1.0.lib;D:/bld/magics_1559240523318/_h_env/Library/lib/cairo.lib;D:/bld/magics_1559240523318/_h_env/Library/lib/glib-2.0.lib" )

set( MAGICS_VERSION           "4.1.0" )
set( MAGICS_GIT_SHA1          "" )
set( MAGICS_GIT_SHA1_SHORT    "" )

### export include paths as absolute paths

set( MAGICS_INCLUDE_DIRS "" )
foreach( path ${MAGICS_SELF_INCLUDE_DIRS} )
  get_filename_component( abspath ${path} ABSOLUTE )
  list( APPEND MAGICS_INCLUDE_DIRS ${abspath} )
endforeach()
list( APPEND MAGICS_INCLUDE_DIRS ${MAGICS_TPL_INCLUDE_DIRS} )

### export definitions

set( MAGICS_DEFINITIONS      ${MAGICS_SELF_DEFINITIONS} ${MAGICS_TPL_DEFINITIONS} )

### export list of all libraries

set( MAGICS_LIBRARIES        ${MAGICS_SELF_LIBRARIES}   ${MAGICS_TPL_LIBRARIES}   )

### export the features provided by the package

set( MAGICS_FEATURES    "TESTS;PYTHON;CAIRO;NETCDF" )
foreach( _f ${MAGICS_FEATURES} )
  set( MAGICS_HAVE_${_f} 1 )
endforeach()

# Has this configuration been exported from a build tree?
set( MAGICS_IS_BUILD_DIR_EXPORT OFF )

if( EXISTS ${MAGICS_CMAKE_DIR}/magics-import.cmake )
  set( MAGICS_IMPORT_FILE "${MAGICS_CMAKE_DIR}/magics-import.cmake" )
  include( ${MAGICS_IMPORT_FILE} )
endif()

# here goes the imports of the TPL's

include( ${CMAKE_CURRENT_LIST_FILE}.tpls OPTIONAL )

# insert definitions for IMPORTED targets

if( NOT magics_BINARY_DIR )

  if( MAGICS_IS_BUILD_DIR_EXPORT )
    include( "D:/bld/magics_1559240523318/work/build/magics-targets.cmake" OPTIONAL )
  else()
    include( "${MAGICS_CMAKE_DIR}/magics-targets.cmake" OPTIONAL )
  endif()

endif()

# publish this file as imported

set( MAGICS_IMPORT_FILE ${CMAKE_CURRENT_LIST_FILE} )
mark_as_advanced( MAGICS_IMPORT_FILE )

# set magics_BASE_DIR for final installations or build directories

if( NOT magics )
  if( MAGICS_IS_BUILD_DIR_EXPORT )
    set( magics_BASE_DIR D:/bld/magics_1559240523318/work/build )
  else()
    get_filename_component( abspath ${CMAKE_CURRENT_LIST_DIR}/../../.. ABSOLUTE )
    set( magics_BASE_DIR ${abspath} )
  endif()
endif()
