#pragma once
#include <string_view>


#define LUE_VERSION "0.2.0"
/* #undef LUE_VERSION_TWEAK */
/* #undef LUE_GIT_REFSPEC */
#define LUE_GIT_SHA1 "476a5e3b96dc909d2b2645f5c9b7db4034dd61f3"
#define LUE_GIT_SHORT_SHA1 "476a5e3"

#define LUE_BUILD_DATA_MODEL
#define LUE_DATA_MODEL_WITH_PYTHON_API

/* #undef LUE_BUILD_FRAMEWORK */
#define LUE_BUILD_FRAMEWORK01 0
/* #undef LUE_FRAMEWORK_WITH_OPENCL */
/* #undef LUE_FRAMEWORK_WITH_PYTHON_API */

#define LUE_VALIDATE_IDXS 0
#define LUE_ASSERT_CONDITIONS 0
/* #undef LUE_BUILD_TEST */


namespace lue {

class BuildOptions
{

public:

    // C++20
    // static constexpr std::string version{LUE_VERSION};

    // NOLINTNEXTLINE(cppcoreguidelines-avoid-c-arrays, hicpp-avoid-c-arrays, modernize-avoid-c-arrays)
    static constexpr char const* version{LUE_VERSION};

    // static constexpr char const* version_tweak{LUE_VERSION_TWEAK};

    // static constexpr char const* git_refspec{LUE_GIT_REFSPEC};

    // NOLINTNEXTLINE(cppcoreguidelines-avoid-c-arrays, hicpp-avoid-c-arrays, modernize-avoid-c-arrays)
    static constexpr char const* git_sha1{LUE_GIT_SHA1};

    // NOLINTNEXTLINE(cppcoreguidelines-avoid-c-arrays, hicpp-avoid-c-arrays, modernize-avoid-c-arrays)
    static constexpr char const* git_short_sha1{LUE_GIT_SHORT_SHA1};

    static constexpr bool build_framework{LUE_BUILD_FRAMEWORK01};

    static constexpr bool validate_idxs{LUE_VALIDATE_IDXS};

    static constexpr bool assert_conditions{LUE_ASSERT_CONDITIONS};

};


// inline constexpr BuildOptions build_options;

}  // namespace lue
